@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.selectdb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cacheSize The cache size for DBCluster.
 * @property cpu The cpu resource amount of DBCluster. Depends on `db_cluster_class`.
 * @property createTime The creation time of the resource.
 * @property dbClusterClass The DBCluster class. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
 * @property dbClusterDescription The DBCluster description.
 * @property dbClusterId The cluster ID.
 * @property dbInstanceId The instance ID.
 * @property engine The Engine of the DBCluster.
 * @property engineVersion The engine version of the DBCluster.
 * @property id
 * @property memory The memory resource amount of DBCluster. Depends on `db_cluster_class`.
 * @property paramChangeLogs The configuration change logs of parameters.
 * @property params The details about each parameter in DBCluster returned.
 * @property paymentType The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
 * @property regionId The ID of region for the cluster.
 * @property status The status of the DBCluster. Valid values: `ACTIVATION`,`CREATING`,`DELETING`,`RESTARTING`,`ORDER_PREPARING`.
 * @property vpcId The ID of the VPC for the cluster.
 * @property zoneId The ID of zone for the cluster.
 */
public data class GetDbClustersCluster(
    public val cacheSize: Int,
    public val cpu: Int,
    public val createTime: String,
    public val dbClusterClass: String,
    public val dbClusterDescription: String,
    public val dbClusterId: String,
    public val dbInstanceId: String,
    public val engine: String,
    public val engineVersion: String,
    public val id: String,
    public val memory: Int,
    public val paramChangeLogs: List<GetDbClustersClusterParamChangeLog>,
    public val params: List<GetDbClustersClusterParam>,
    public val paymentType: String,
    public val regionId: String,
    public val status: String,
    public val vpcId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.selectdb.outputs.GetDbClustersCluster): GetDbClustersCluster = GetDbClustersCluster(
            cacheSize = javaType.cacheSize(),
            cpu = javaType.cpu(),
            createTime = javaType.createTime(),
            dbClusterClass = javaType.dbClusterClass(),
            dbClusterDescription = javaType.dbClusterDescription(),
            dbClusterId = javaType.dbClusterId(),
            dbInstanceId = javaType.dbInstanceId(),
            engine = javaType.engine(),
            engineVersion = javaType.engineVersion(),
            id = javaType.id(),
            memory = javaType.memory(),
            paramChangeLogs = javaType.paramChangeLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.selectdb.kotlin.outputs.GetDbClustersClusterParamChangeLog.Companion.toKotlin(args0)
                })
            }),
            params = javaType.params().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.selectdb.kotlin.outputs.GetDbClustersClusterParam.Companion.toKotlin(args0)
                })
            }),
            paymentType = javaType.paymentType(),
            regionId = javaType.regionId(),
            status = javaType.status(),
            vpcId = javaType.vpcId(),
            zoneId = javaType.zoneId(),
        )
    }
}
