@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.selectdb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property comment The comments on the parameter.
 * @property defaultValue The default value of the parameter.
 * @property isDynamic Indicates whether the parameter immediately takes effect without requiring a restart.
 * @property isUserModifiable Indicates whether the parameter is modifiable.
 * @property name Changed parameter name.
 * @property optional The value range of the parameter.
 * @property paramCategory The category of the parameter.
 * @property value The new value of Parameter.
 */
public data class GetDbClustersClusterParam(
    public val comment: String,
    public val defaultValue: String,
    public val isDynamic: Int,
    public val isUserModifiable: Int,
    public val name: String,
    public val optional: Int,
    public val paramCategory: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.selectdb.outputs.GetDbClustersClusterParam): GetDbClustersClusterParam = GetDbClustersClusterParam(
            comment = javaType.comment(),
            defaultValue = javaType.defaultValue(),
            isDynamic = javaType.isDynamic(),
            isUserModifiable = javaType.isUserModifiable(),
            name = javaType.name(),
            optional = javaType.optional(),
            paramCategory = javaType.paramCategory(),
            `value` = javaType.`value`(),
        )
    }
}
