@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.selectdb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property configId The id of parameter change.
 * @property gmtCreated When the parameter change is created.
 * @property gmtModified When the parameter change is modified.
 * @property isApplied Whether the parameter changing is applied.
 * @property name Changed parameter name.
 * @property newValue The new value of parameter.
 * @property oldValue The old value of parameter.
 */
public data class GetDbClustersClusterParamChangeLog(
    public val configId: Int,
    public val gmtCreated: String,
    public val gmtModified: String,
    public val isApplied: Int,
    public val name: String,
    public val newValue: String,
    public val oldValue: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.selectdb.outputs.GetDbClustersClusterParamChangeLog): GetDbClustersClusterParamChangeLog = GetDbClustersClusterParamChangeLog(
            configId = javaType.configId(),
            gmtCreated = javaType.gmtCreated(),
            gmtModified = javaType.gmtModified(),
            isApplied = javaType.isApplied(),
            name = javaType.name(),
            newValue = javaType.newValue(),
            oldValue = javaType.oldValue(),
        )
    }
}
