@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.selectdb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cacheSizePostpaid The sum of cache size for every `PayAsYouGo` clusters in DBInstance.
 * @property cacheSizePrepaid The sum of cache size for every `Subscription` clusters in DBInstance.
 * @property clusterCountPostpaid The sum of cluster counts for `PayAsYouGo` clusters in DBInstance.
 * @property clusterCountPrepaid The sum of cluster counts for `Subscription` clusters in DBInstance.
 * @property cpuPostpaid The sum of cpu resource amount for every `PayAsYouGo` clusters in DBInstance.
 * @property cpuPrepaid The sum of cpu resource amount for every `Subscription` clusters in DBInstance.
 * @property dbInstanceDescription The DBInstance description.
 * @property dbInstanceId The instance ID.
 * @property engine The Engine of the DBInstance.
 * @property engineMinorVersion The engine minor version of the DBInstance.
 * @property engineVersion The engine version of the DBInstance.
 * @property gmtCreated The time when DBInstance is created.
 * @property gmtExpired The time when DBInstance will be expired. Available on `Subscription` DBInstance.
 * @property gmtModified The time when DBInstance is modified.
 * @property id
 * @property lockMode The lock mode of the instance. Set the value to lock, which specifies that the instance is locked when it automatically expires or has an overdue payment.
 * @property lockReason The reason why the instance is locked.
 * @property memoryPostpaid The sum of memory resource amount offor every `PayAsYouGo` clusters in DBInstance.
 * @property memoryPrepaid The sum of memory resource amount offor every `Subscription` clusters in DBInstance.
 * @property paymentType The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
 * @property regionId The ID of region for DBInstance.
 * @property status The status of the DBInstance. Valid values: `ACTIVATION`,`CREATING`,`DELETING`,`RESTARTING`,`ORDER_PREPARING`.
 * @property subDomain The sub domain of DBInstance.
 * @property vpcId The ID of the VPC for DBInstance.
 * @property vswitchId The ID of vswitch for DBInstance.
 * @property zoneId The ID of zone for DBInstance.
 */
public data class GetDbInstancesInstance(
    public val cacheSizePostpaid: Int,
    public val cacheSizePrepaid: Int,
    public val clusterCountPostpaid: Int,
    public val clusterCountPrepaid: Int,
    public val cpuPostpaid: Int,
    public val cpuPrepaid: Int,
    public val dbInstanceDescription: String,
    public val dbInstanceId: String,
    public val engine: String,
    public val engineMinorVersion: String,
    public val engineVersion: String,
    public val gmtCreated: String,
    public val gmtExpired: String,
    public val gmtModified: String,
    public val id: String,
    public val lockMode: String,
    public val lockReason: String,
    public val memoryPostpaid: Int,
    public val memoryPrepaid: Int,
    public val paymentType: String,
    public val regionId: String,
    public val status: String,
    public val subDomain: String,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.selectdb.outputs.GetDbInstancesInstance): GetDbInstancesInstance = GetDbInstancesInstance(
            cacheSizePostpaid = javaType.cacheSizePostpaid(),
            cacheSizePrepaid = javaType.cacheSizePrepaid(),
            clusterCountPostpaid = javaType.clusterCountPostpaid(),
            clusterCountPrepaid = javaType.clusterCountPrepaid(),
            cpuPostpaid = javaType.cpuPostpaid(),
            cpuPrepaid = javaType.cpuPrepaid(),
            dbInstanceDescription = javaType.dbInstanceDescription(),
            dbInstanceId = javaType.dbInstanceId(),
            engine = javaType.engine(),
            engineMinorVersion = javaType.engineMinorVersion(),
            engineVersion = javaType.engineVersion(),
            gmtCreated = javaType.gmtCreated(),
            gmtExpired = javaType.gmtExpired(),
            gmtModified = javaType.gmtModified(),
            id = javaType.id(),
            lockMode = javaType.lockMode(),
            lockReason = javaType.lockReason(),
            memoryPostpaid = javaType.memoryPostpaid(),
            memoryPrepaid = javaType.memoryPrepaid(),
            paymentType = javaType.paymentType(),
            regionId = javaType.regionId(),
            status = javaType.status(),
            subDomain = javaType.subDomain(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
