@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.selectdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getDbInstances.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instances A list of SelectDB DBInstance. Each element contains the following attributes:
 * @property outputFile
 * @property tags
 */
public data class GetDbInstancesResult(
    public val id: String,
    public val ids: List<String>,
    public val instances: List<GetDbInstancesInstance>,
    public val outputFile: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.selectdb.outputs.GetDbInstancesResult): GetDbInstancesResult = GetDbInstancesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.selectdb.kotlin.outputs.GetDbInstancesInstance.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
