@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Portfolio].
 */
@PulumiTagMarker
public class PortfolioResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PortfolioArgs = PortfolioArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PortfolioArgsBuilder.() -> Unit) {
        val builder = PortfolioArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Portfolio {
        val builtJavaResource = com.pulumi.alicloud.servicecatalog.Portfolio(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Portfolio(builtJavaResource)
    }
}

/**
 * Provides a Service Catalog Portfolio resource.
 * For information about Service Catalog Portfolio and how to use it, see [What is Portfolio](https://www.alibabacloud.com/help/en/service-catalog/developer-reference/api-servicecatalog-2021-09-01-createportfolio).
 * > **NOTE:** Available since v1.204.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const _default = new alicloud.servicecatalog.Portfolio("default", {
 *     portfolioName: name,
 *     providerName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.servicecatalog.Portfolio("default",
 *     portfolio_name=name,
 *     provider_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = new AliCloud.ServiceCatalog.Portfolio("default", new()
 *     {
 *         PortfolioName = name,
 *         ProviderName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := servicecatalog.NewPortfolio(ctx, "default", &servicecatalog.PortfolioArgs{
 * 			PortfolioName: pulumi.String(name),
 * 			ProviderName:  pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.servicecatalog.Portfolio;
 * import com.pulumi.alicloud.servicecatalog.PortfolioArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var default_ = new Portfolio("default", PortfolioArgs.builder()
 *             .portfolioName(name)
 *             .providerName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   default:
 *     type: alicloud:servicecatalog:Portfolio
 *     properties:
 *       portfolioName: ${name}
 *       providerName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Service Catalog Portfolio can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:servicecatalog/portfolio:Portfolio example <id>
 * ```
 */
public class Portfolio internal constructor(
    override val javaResource: com.pulumi.alicloud.servicecatalog.Portfolio,
) : KotlinCustomResource(javaResource, PortfolioMapper) {
    /**
     * The creation time of the portfolio.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The description of the portfolio. The value must be 1 to 128 characters in length.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the portfolio.
     */
    public val portfolioArn: Output<String>
        get() = javaResource.portfolioArn().applyValue({ args0 -> args0 })

    /**
     * The name of the portfolio. The value must be 1 to 128 characters in length.
     */
    public val portfolioName: Output<String>
        get() = javaResource.portfolioName().applyValue({ args0 -> args0 })

    /**
     * The provider name of the portfolio. The value must be 1 to 128 characters in length.
     */
    public val providerName: Output<String>
        get() = javaResource.providerName().applyValue({ args0 -> args0 })
}

public object PortfolioMapper : ResourceMapper<Portfolio> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.servicecatalog.Portfolio::class == javaResource::class

    override fun map(javaResource: Resource): Portfolio = Portfolio(
        javaResource as
            com.pulumi.alicloud.servicecatalog.Portfolio,
    )
}

/**
 * @see [Portfolio].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Portfolio].
 */
public suspend fun portfolio(name: String, block: suspend PortfolioResourceBuilder.() -> Unit): Portfolio {
    val builder = PortfolioResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Portfolio].
 * @param name The _unique_ name of the resulting resource.
 */
public fun portfolio(name: String): Portfolio {
    val builder = PortfolioResourceBuilder()
    builder.name(name)
    return builder.build()
}
