@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin

import com.pulumi.alicloud.servicecatalog.PortfolioArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Service Catalog Portfolio resource.
 * For information about Service Catalog Portfolio and how to use it, see [What is Portfolio](https://www.alibabacloud.com/help/en/service-catalog/developer-reference/api-servicecatalog-2021-09-01-createportfolio).
 * > **NOTE:** Available since v1.204.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const _default = new alicloud.servicecatalog.Portfolio("default", {
 *     portfolioName: name,
 *     providerName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.servicecatalog.Portfolio("default",
 *     portfolio_name=name,
 *     provider_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = new AliCloud.ServiceCatalog.Portfolio("default", new()
 *     {
 *         PortfolioName = name,
 *         ProviderName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := servicecatalog.NewPortfolio(ctx, "default", &servicecatalog.PortfolioArgs{
 * 			PortfolioName: pulumi.String(name),
 * 			ProviderName:  pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.servicecatalog.Portfolio;
 * import com.pulumi.alicloud.servicecatalog.PortfolioArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var default_ = new Portfolio("default", PortfolioArgs.builder()
 *             .portfolioName(name)
 *             .providerName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   default:
 *     type: alicloud:servicecatalog:Portfolio
 *     properties:
 *       portfolioName: ${name}
 *       providerName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Service Catalog Portfolio can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:servicecatalog/portfolio:Portfolio example <id>
 * ```
 * @property description The description of the portfolio. The value must be 1 to 128 characters in length.
 * @property portfolioName The name of the portfolio. The value must be 1 to 128 characters in length.
 * @property providerName The provider name of the portfolio. The value must be 1 to 128 characters in length.
 */
public data class PortfolioArgs(
    public val description: Output<String>? = null,
    public val portfolioName: Output<String>? = null,
    public val providerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicecatalog.PortfolioArgs> {
    override fun toJava(): com.pulumi.alicloud.servicecatalog.PortfolioArgs =
        com.pulumi.alicloud.servicecatalog.PortfolioArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .portfolioName(portfolioName?.applyValue({ args0 -> args0 }))
            .providerName(providerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PortfolioArgs].
 */
@PulumiTagMarker
public class PortfolioArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var portfolioName: Output<String>? = null

    private var providerName: Output<String>? = null

    /**
     * @param value The description of the portfolio. The value must be 1 to 128 characters in length.
     */
    @JvmName("ortnajsbqwvdivkt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the portfolio. The value must be 1 to 128 characters in length.
     */
    @JvmName("gkbfnsuelddhmqxw")
    public suspend fun portfolioName(`value`: Output<String>) {
        this.portfolioName = value
    }

    /**
     * @param value The provider name of the portfolio. The value must be 1 to 128 characters in length.
     */
    @JvmName("xdbtoeqlxhliufbj")
    public suspend fun providerName(`value`: Output<String>) {
        this.providerName = value
    }

    /**
     * @param value The description of the portfolio. The value must be 1 to 128 characters in length.
     */
    @JvmName("egpxjdchtslxjywt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the portfolio. The value must be 1 to 128 characters in length.
     */
    @JvmName("fpordxfexdnmwiom")
    public suspend fun portfolioName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portfolioName = mapped
    }

    /**
     * @param value The provider name of the portfolio. The value must be 1 to 128 characters in length.
     */
    @JvmName("gweprfohmgsghhfj")
    public suspend fun providerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerName = mapped
    }

    internal fun build(): PortfolioArgs = PortfolioArgs(
        description = description,
        portfolioName = portfolioName,
        providerName = providerName,
    )
}
