@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin

import com.pulumi.alicloud.servicecatalog.kotlin.outputs.ProvisionedProductOutput
import com.pulumi.alicloud.servicecatalog.kotlin.outputs.ProvisionedProductParameter
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.servicecatalog.kotlin.outputs.ProvisionedProductOutput.Companion.toKotlin as provisionedProductOutputToKotlin
import com.pulumi.alicloud.servicecatalog.kotlin.outputs.ProvisionedProductParameter.Companion.toKotlin as provisionedProductParameterToKotlin

/**
 * Builder for [ProvisionedProduct].
 */
@PulumiTagMarker
public class ProvisionedProductResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProvisionedProductArgs = ProvisionedProductArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProvisionedProductArgsBuilder.() -> Unit) {
        val builder = ProvisionedProductArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProvisionedProduct {
        val builtJavaResource =
            com.pulumi.alicloud.servicecatalog.ProvisionedProduct(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProvisionedProduct(builtJavaResource)
    }
}

/**
 * Provides a Service Catalog Provisioned Product resource.
 * For information about Service Catalog Provisioned Product and how to use it, see [What is Provisioned Product](https://www.alibabacloud.com/help/en/service-catalog/developer-reference/api-servicecatalog-2021-09-01-launchproduct).
 * > **NOTE:** Available in v1.196.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-testAccServiceCatalogProvisionedProduct";
 * const _default = new alicloud.servicecatalog.ProvisionedProduct("default", {
 *     provisionedProductName: name,
 *     stackRegionId: "cn-hangzhou",
 *     productVersionId: "pv-bp1d7dxy2pcc1g",
 *     productId: "prod-bp1u3dkc282cwd",
 *     portfolioId: "port-bp119dvn27jccw",
 *     tags: {
 *         v1: "tf-test",
 *     },
 *     parameters: [{
 *         parameterKey: "role_name",
 *         parameterValue: name,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-testAccServiceCatalogProvisionedProduct"
 * default = alicloud.servicecatalog.ProvisionedProduct("default",
 *     provisioned_product_name=name,
 *     stack_region_id="cn-hangzhou",
 *     product_version_id="pv-bp1d7dxy2pcc1g",
 *     product_id="prod-bp1u3dkc282cwd",
 *     portfolio_id="port-bp119dvn27jccw",
 *     tags={
 *         "v1": "tf-test",
 *     },
 *     parameters=[{
 *         "parameter_key": "role_name",
 *         "parameter_value": name,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-testAccServiceCatalogProvisionedProduct";
 *     var @default = new AliCloud.ServiceCatalog.ProvisionedProduct("default", new()
 *     {
 *         ProvisionedProductName = name,
 *         StackRegionId = "cn-hangzhou",
 *         ProductVersionId = "pv-bp1d7dxy2pcc1g",
 *         ProductId = "prod-bp1u3dkc282cwd",
 *         PortfolioId = "port-bp119dvn27jccw",
 *         Tags =
 *         {
 *             { "v1", "tf-test" },
 *         },
 *         Parameters = new[]
 *         {
 *             new AliCloud.ServiceCatalog.Inputs.ProvisionedProductParameterArgs
 *             {
 *                 ParameterKey = "role_name",
 *                 ParameterValue = name,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-testAccServiceCatalogProvisionedProduct"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := servicecatalog.NewProvisionedProduct(ctx, "default", &servicecatalog.ProvisionedProductArgs{
 * 			ProvisionedProductName: pulumi.String(name),
 * 			StackRegionId:          pulumi.String("cn-hangzhou"),
 * 			ProductVersionId:       pulumi.String("pv-bp1d7dxy2pcc1g"),
 * 			ProductId:              pulumi.String("prod-bp1u3dkc282cwd"),
 * 			PortfolioId:            pulumi.String("port-bp119dvn27jccw"),
 * 			Tags: pulumi.StringMap{
 * 				"v1": pulumi.String("tf-test"),
 * 			},
 * 			Parameters: servicecatalog.ProvisionedProductParameterArray{
 * 				&servicecatalog.ProvisionedProductParameterArgs{
 * 					ParameterKey:   pulumi.String("role_name"),
 * 					ParameterValue: pulumi.String(name),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.servicecatalog.ProvisionedProduct;
 * import com.pulumi.alicloud.servicecatalog.ProvisionedProductArgs;
 * import com.pulumi.alicloud.servicecatalog.inputs.ProvisionedProductParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-testAccServiceCatalogProvisionedProduct");
 *         var default_ = new ProvisionedProduct("default", ProvisionedProductArgs.builder()
 *             .provisionedProductName(name)
 *             .stackRegionId("cn-hangzhou")
 *             .productVersionId("pv-bp1d7dxy2pcc1g")
 *             .productId("prod-bp1u3dkc282cwd")
 *             .portfolioId("port-bp119dvn27jccw")
 *             .tags(Map.of("v1", "tf-test"))
 *             .parameters(ProvisionedProductParameterArgs.builder()
 *                 .parameterKey("role_name")
 *                 .parameterValue(name)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-testAccServiceCatalogProvisionedProduct
 * resources:
 *   default:
 *     type: alicloud:servicecatalog:ProvisionedProduct
 *     properties:
 *       provisionedProductName: ${name}
 *       stackRegionId: cn-hangzhou
 *       productVersionId: pv-bp1d7dxy2pcc1g
 *       productId: prod-bp1u3dkc282cwd
 *       portfolioId: port-bp119dvn27jccw
 *       tags:
 *         v1: tf-test
 *       parameters:
 *         - parameterKey: role_name
 *           parameterValue: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Service Catalog Provisioned Product can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:servicecatalog/provisionedProduct:ProvisionedProduct example <id>
 * ```
 */
public class ProvisionedProduct internal constructor(
    override val javaResource: com.pulumi.alicloud.servicecatalog.ProvisionedProduct,
) : KotlinCustomResource(javaResource, ProvisionedProductMapper) {
    /**
     * The creation time of the product instance
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The ID of the last instance operation task
     */
    public val lastProvisioningTaskId: Output<String>
        get() = javaResource.lastProvisioningTaskId().applyValue({ args0 -> args0 })

    /**
     * The ID of the last successful instance operation task
     */
    public val lastSuccessfulProvisioningTaskId: Output<String>
        get() = javaResource.lastSuccessfulProvisioningTaskId().applyValue({ args0 -> args0 })

    /**
     * The ID of the last task
     */
    public val lastTaskId: Output<String>
        get() = javaResource.lastTaskId().applyValue({ args0 -> args0 })

    /**
     * The output value of the template.
     */
    public val outputs: Output<List<ProvisionedProductOutput>>
        get() = javaResource.outputs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    provisionedProductOutputToKotlin(args0)
                })
            })
        })

    /**
     * The RAM entity ID of the owner
     */
    public val ownerPrincipalId: Output<String>
        get() = javaResource.ownerPrincipalId().applyValue({ args0 -> args0 })

    /**
     * The RAM entity type of the owner
     */
    public val ownerPrincipalType: Output<String>
        get() = javaResource.ownerPrincipalType().applyValue({ args0 -> args0 })

    /**
     * Template parameters entered by the user.The maximum value of N is 200.See the following `Block Parameters`.
     */
    public val parameters: Output<List<ProvisionedProductParameter>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> provisionedProductParameterToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Product mix ID.> When there is a default Startup option, there is no need to fill in the portfolio. When there is no default Startup option, you must fill in the portfolio.
     */
    public val portfolioId: Output<String>?
        get() = javaResource.portfolioId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Product ID.
     */
    public val productId: Output<String>
        get() = javaResource.productId().applyValue({ args0 -> args0 })

    /**
     * The name of the product
     */
    public val productName: Output<String>
        get() = javaResource.productName().applyValue({ args0 -> args0 })

    /**
     * Product version ID.
     */
    public val productVersionId: Output<String>
        get() = javaResource.productVersionId().applyValue({ args0 -> args0 })

    /**
     * The name of the product version
     */
    public val productVersionName: Output<String>
        get() = javaResource.productVersionName().applyValue({ args0 -> args0 })

    /**
     * The ARN of the product instance
     */
    public val provisionedProductArn: Output<String>
        get() = javaResource.provisionedProductArn().applyValue({ args0 -> args0 })

    /**
     * The ID of the instance.
     */
    public val provisionedProductId: Output<String>
        get() = javaResource.provisionedProductId().applyValue({ args0 -> args0 })

    /**
     * The name of the instance.The length is 1~128 characters.
     */
    public val provisionedProductName: Output<String>
        get() = javaResource.provisionedProductName().applyValue({ args0 -> args0 })

    /**
     * Instance type.The value is RosStack, which indicates the stack of Alibaba Cloud resource orchestration service (ROS).
     */
    public val provisionedProductType: Output<String>
        get() = javaResource.provisionedProductType().applyValue({ args0 -> args0 })

    /**
     * The ID of the ROS stack
     */
    public val stackId: Output<String>
        get() = javaResource.stackId().applyValue({ args0 -> args0 })

    /**
     * The ID of the region to which the resource stack of the Alibaba Cloud resource orchestration service (ROS) belongs.
     */
    public val stackRegionId: Output<String>
        get() = javaResource.stackRegionId().applyValue({ args0 -> args0 })

    /**
     * Instance status
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The status message of the product instance
     */
    public val statusMessage: Output<String>
        get() = javaResource.statusMessage().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object ProvisionedProductMapper : ResourceMapper<ProvisionedProduct> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.servicecatalog.ProvisionedProduct::class == javaResource::class

    override fun map(javaResource: Resource): ProvisionedProduct = ProvisionedProduct(
        javaResource as
            com.pulumi.alicloud.servicecatalog.ProvisionedProduct,
    )
}

/**
 * @see [ProvisionedProduct].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProvisionedProduct].
 */
public suspend fun provisionedProduct(
    name: String,
    block: suspend ProvisionedProductResourceBuilder.() -> Unit,
): ProvisionedProduct {
    val builder = ProvisionedProductResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProvisionedProduct].
 * @param name The _unique_ name of the resulting resource.
 */
public fun provisionedProduct(name: String): ProvisionedProduct {
    val builder = ProvisionedProductResourceBuilder()
    builder.name(name)
    return builder.build()
}
