@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin

import com.pulumi.alicloud.servicecatalog.ProvisionedProductArgs.builder
import com.pulumi.alicloud.servicecatalog.kotlin.inputs.ProvisionedProductParameterArgs
import com.pulumi.alicloud.servicecatalog.kotlin.inputs.ProvisionedProductParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Service Catalog Provisioned Product resource.
 * For information about Service Catalog Provisioned Product and how to use it, see [What is Provisioned Product](https://www.alibabacloud.com/help/en/service-catalog/developer-reference/api-servicecatalog-2021-09-01-launchproduct).
 * > **NOTE:** Available in v1.196.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-testAccServiceCatalogProvisionedProduct";
 * const _default = new alicloud.servicecatalog.ProvisionedProduct("default", {
 *     provisionedProductName: name,
 *     stackRegionId: "cn-hangzhou",
 *     productVersionId: "pv-bp1d7dxy2pcc1g",
 *     productId: "prod-bp1u3dkc282cwd",
 *     portfolioId: "port-bp119dvn27jccw",
 *     tags: {
 *         v1: "tf-test",
 *     },
 *     parameters: [{
 *         parameterKey: "role_name",
 *         parameterValue: name,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-testAccServiceCatalogProvisionedProduct"
 * default = alicloud.servicecatalog.ProvisionedProduct("default",
 *     provisioned_product_name=name,
 *     stack_region_id="cn-hangzhou",
 *     product_version_id="pv-bp1d7dxy2pcc1g",
 *     product_id="prod-bp1u3dkc282cwd",
 *     portfolio_id="port-bp119dvn27jccw",
 *     tags={
 *         "v1": "tf-test",
 *     },
 *     parameters=[{
 *         "parameter_key": "role_name",
 *         "parameter_value": name,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-testAccServiceCatalogProvisionedProduct";
 *     var @default = new AliCloud.ServiceCatalog.ProvisionedProduct("default", new()
 *     {
 *         ProvisionedProductName = name,
 *         StackRegionId = "cn-hangzhou",
 *         ProductVersionId = "pv-bp1d7dxy2pcc1g",
 *         ProductId = "prod-bp1u3dkc282cwd",
 *         PortfolioId = "port-bp119dvn27jccw",
 *         Tags =
 *         {
 *             { "v1", "tf-test" },
 *         },
 *         Parameters = new[]
 *         {
 *             new AliCloud.ServiceCatalog.Inputs.ProvisionedProductParameterArgs
 *             {
 *                 ParameterKey = "role_name",
 *                 ParameterValue = name,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-testAccServiceCatalogProvisionedProduct"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := servicecatalog.NewProvisionedProduct(ctx, "default", &servicecatalog.ProvisionedProductArgs{
 * 			ProvisionedProductName: pulumi.String(name),
 * 			StackRegionId:          pulumi.String("cn-hangzhou"),
 * 			ProductVersionId:       pulumi.String("pv-bp1d7dxy2pcc1g"),
 * 			ProductId:              pulumi.String("prod-bp1u3dkc282cwd"),
 * 			PortfolioId:            pulumi.String("port-bp119dvn27jccw"),
 * 			Tags: pulumi.StringMap{
 * 				"v1": pulumi.String("tf-test"),
 * 			},
 * 			Parameters: servicecatalog.ProvisionedProductParameterArray{
 * 				&servicecatalog.ProvisionedProductParameterArgs{
 * 					ParameterKey:   pulumi.String("role_name"),
 * 					ParameterValue: pulumi.String(name),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.servicecatalog.ProvisionedProduct;
 * import com.pulumi.alicloud.servicecatalog.ProvisionedProductArgs;
 * import com.pulumi.alicloud.servicecatalog.inputs.ProvisionedProductParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-testAccServiceCatalogProvisionedProduct");
 *         var default_ = new ProvisionedProduct("default", ProvisionedProductArgs.builder()
 *             .provisionedProductName(name)
 *             .stackRegionId("cn-hangzhou")
 *             .productVersionId("pv-bp1d7dxy2pcc1g")
 *             .productId("prod-bp1u3dkc282cwd")
 *             .portfolioId("port-bp119dvn27jccw")
 *             .tags(Map.of("v1", "tf-test"))
 *             .parameters(ProvisionedProductParameterArgs.builder()
 *                 .parameterKey("role_name")
 *                 .parameterValue(name)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-testAccServiceCatalogProvisionedProduct
 * resources:
 *   default:
 *     type: alicloud:servicecatalog:ProvisionedProduct
 *     properties:
 *       provisionedProductName: ${name}
 *       stackRegionId: cn-hangzhou
 *       productVersionId: pv-bp1d7dxy2pcc1g
 *       productId: prod-bp1u3dkc282cwd
 *       portfolioId: port-bp119dvn27jccw
 *       tags:
 *         v1: tf-test
 *       parameters:
 *         - parameterKey: role_name
 *           parameterValue: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Service Catalog Provisioned Product can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:servicecatalog/provisionedProduct:ProvisionedProduct example <id>
 * ```
 * @property parameters Template parameters entered by the user.The maximum value of N is 200.See the following `Block Parameters`.
 * @property portfolioId Product mix ID.> When there is a default Startup option, there is no need to fill in the portfolio. When there is no default Startup option, you must fill in the portfolio.
 * @property productId Product ID.
 * @property productVersionId Product version ID.
 * @property provisionedProductId The ID of the instance.
 * @property provisionedProductName The name of the instance.The length is 1~128 characters.
 * @property stackRegionId The ID of the region to which the resource stack of the Alibaba Cloud resource orchestration service (ROS) belongs.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class ProvisionedProductArgs(
    public val parameters: Output<List<ProvisionedProductParameterArgs>>? = null,
    public val portfolioId: Output<String>? = null,
    public val productId: Output<String>? = null,
    public val productVersionId: Output<String>? = null,
    public val provisionedProductId: Output<String>? = null,
    public val provisionedProductName: Output<String>? = null,
    public val stackRegionId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicecatalog.ProvisionedProductArgs> {
    override fun toJava(): com.pulumi.alicloud.servicecatalog.ProvisionedProductArgs =
        com.pulumi.alicloud.servicecatalog.ProvisionedProductArgs.builder()
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .portfolioId(portfolioId?.applyValue({ args0 -> args0 }))
            .productId(productId?.applyValue({ args0 -> args0 }))
            .productVersionId(productVersionId?.applyValue({ args0 -> args0 }))
            .provisionedProductId(provisionedProductId?.applyValue({ args0 -> args0 }))
            .provisionedProductName(provisionedProductName?.applyValue({ args0 -> args0 }))
            .stackRegionId(stackRegionId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ProvisionedProductArgs].
 */
@PulumiTagMarker
public class ProvisionedProductArgsBuilder internal constructor() {
    private var parameters: Output<List<ProvisionedProductParameterArgs>>? = null

    private var portfolioId: Output<String>? = null

    private var productId: Output<String>? = null

    private var productVersionId: Output<String>? = null

    private var provisionedProductId: Output<String>? = null

    private var provisionedProductName: Output<String>? = null

    private var stackRegionId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Template parameters entered by the user.The maximum value of N is 200.See the following `Block Parameters`.
     */
    @JvmName("oysoxklnfnwgaomi")
    public suspend fun parameters(`value`: Output<List<ProvisionedProductParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("dwhcqikxjmqobiqa")
    public suspend fun parameters(vararg values: Output<ProvisionedProductParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Template parameters entered by the user.The maximum value of N is 200.See the following `Block Parameters`.
     */
    @JvmName("pvjosloydtgepwmy")
    public suspend fun parameters(values: List<Output<ProvisionedProductParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value Product mix ID.> When there is a default Startup option, there is no need to fill in the portfolio. When there is no default Startup option, you must fill in the portfolio.
     */
    @JvmName("qfhohadukthenxdc")
    public suspend fun portfolioId(`value`: Output<String>) {
        this.portfolioId = value
    }

    /**
     * @param value Product ID.
     */
    @JvmName("pxhjtwnhelkchhpn")
    public suspend fun productId(`value`: Output<String>) {
        this.productId = value
    }

    /**
     * @param value Product version ID.
     */
    @JvmName("yembhkaggryjkvtu")
    public suspend fun productVersionId(`value`: Output<String>) {
        this.productVersionId = value
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("fyxdofgmmgklslcv")
    public suspend fun provisionedProductId(`value`: Output<String>) {
        this.provisionedProductId = value
    }

    /**
     * @param value The name of the instance.The length is 1~128 characters.
     */
    @JvmName("thhumyqlqkdcihba")
    public suspend fun provisionedProductName(`value`: Output<String>) {
        this.provisionedProductName = value
    }

    /**
     * @param value The ID of the region to which the resource stack of the Alibaba Cloud resource orchestration service (ROS) belongs.
     */
    @JvmName("qwstnytiixfcjadk")
    public suspend fun stackRegionId(`value`: Output<String>) {
        this.stackRegionId = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("vcoodjinmjrfnudf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Template parameters entered by the user.The maximum value of N is 200.See the following `Block Parameters`.
     */
    @JvmName("utwkowpplwsehrga")
    public suspend fun parameters(`value`: List<ProvisionedProductParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Template parameters entered by the user.The maximum value of N is 200.See the following `Block Parameters`.
     */
    @JvmName("vmgwbhanudmngrbu")
    public suspend fun parameters(argument: List<suspend ProvisionedProductParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ProvisionedProductParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Template parameters entered by the user.The maximum value of N is 200.See the following `Block Parameters`.
     */
    @JvmName("qhiytbckrdneamho")
    public suspend fun parameters(vararg argument: suspend ProvisionedProductParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ProvisionedProductParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Template parameters entered by the user.The maximum value of N is 200.See the following `Block Parameters`.
     */
    @JvmName("adjcpcepehttuspi")
    public suspend fun parameters(argument: suspend ProvisionedProductParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ProvisionedProductParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Template parameters entered by the user.The maximum value of N is 200.See the following `Block Parameters`.
     */
    @JvmName("jprhqyuxfrxolutt")
    public suspend fun parameters(vararg values: ProvisionedProductParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Product mix ID.> When there is a default Startup option, there is no need to fill in the portfolio. When there is no default Startup option, you must fill in the portfolio.
     */
    @JvmName("mxqsrotoqakpisuh")
    public suspend fun portfolioId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portfolioId = mapped
    }

    /**
     * @param value Product ID.
     */
    @JvmName("ixlssqraqfhsbfov")
    public suspend fun productId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productId = mapped
    }

    /**
     * @param value Product version ID.
     */
    @JvmName("tycrcjnfmhjmbhef")
    public suspend fun productVersionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productVersionId = mapped
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("jasahdoxowaakrno")
    public suspend fun provisionedProductId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionedProductId = mapped
    }

    /**
     * @param value The name of the instance.The length is 1~128 characters.
     */
    @JvmName("vangayhbquflodmg")
    public suspend fun provisionedProductName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionedProductName = mapped
    }

    /**
     * @param value The ID of the region to which the resource stack of the Alibaba Cloud resource orchestration service (ROS) belongs.
     */
    @JvmName("ygbtkudsagjwmhhb")
    public suspend fun stackRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackRegionId = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("myhhaawmyhvlqrjh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("ckwkeuqlhirmijac")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ProvisionedProductArgs = ProvisionedProductArgs(
        parameters = parameters,
        portfolioId = portfolioId,
        productId = productId,
        productVersionId = productVersionId,
        provisionedProductId = provisionedProductId,
        provisionedProductName = provisionedProductName,
        stackRegionId = stackRegionId,
        tags = tags,
    )
}
