@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin

import com.pulumi.alicloud.servicecatalog.ServicecatalogFunctions.getEndUserProductsPlain
import com.pulumi.alicloud.servicecatalog.ServicecatalogFunctions.getLaunchOptionsPlain
import com.pulumi.alicloud.servicecatalog.ServicecatalogFunctions.getPortfoliosPlain
import com.pulumi.alicloud.servicecatalog.ServicecatalogFunctions.getProductAsEndUsersPlain
import com.pulumi.alicloud.servicecatalog.ServicecatalogFunctions.getProductVersionsPlain
import com.pulumi.alicloud.servicecatalog.ServicecatalogFunctions.getProvisionedProductsPlain
import com.pulumi.alicloud.servicecatalog.kotlin.inputs.GetEndUserProductsPlainArgs
import com.pulumi.alicloud.servicecatalog.kotlin.inputs.GetEndUserProductsPlainArgsBuilder
import com.pulumi.alicloud.servicecatalog.kotlin.inputs.GetLaunchOptionsPlainArgs
import com.pulumi.alicloud.servicecatalog.kotlin.inputs.GetLaunchOptionsPlainArgsBuilder
import com.pulumi.alicloud.servicecatalog.kotlin.inputs.GetPortfoliosPlainArgs
import com.pulumi.alicloud.servicecatalog.kotlin.inputs.GetPortfoliosPlainArgsBuilder
import com.pulumi.alicloud.servicecatalog.kotlin.inputs.GetProductAsEndUsersPlainArgs
import com.pulumi.alicloud.servicecatalog.kotlin.inputs.GetProductAsEndUsersPlainArgsBuilder
import com.pulumi.alicloud.servicecatalog.kotlin.inputs.GetProductVersionsPlainArgs
import com.pulumi.alicloud.servicecatalog.kotlin.inputs.GetProductVersionsPlainArgsBuilder
import com.pulumi.alicloud.servicecatalog.kotlin.inputs.GetProvisionedProductsPlainArgs
import com.pulumi.alicloud.servicecatalog.kotlin.inputs.GetProvisionedProductsPlainArgsBuilder
import com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetEndUserProductsResult
import com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetLaunchOptionsResult
import com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetPortfoliosResult
import com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetProductAsEndUsersResult
import com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetProductVersionsResult
import com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetProvisionedProductsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetEndUserProductsResult.Companion.toKotlin as getEndUserProductsResultToKotlin
import com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetLaunchOptionsResult.Companion.toKotlin as getLaunchOptionsResultToKotlin
import com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetPortfoliosResult.Companion.toKotlin as getPortfoliosResultToKotlin
import com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetProductAsEndUsersResult.Companion.toKotlin as getProductAsEndUsersResultToKotlin
import com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetProductVersionsResult.Companion.toKotlin as getProductVersionsResultToKotlin
import com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetProvisionedProductsResult.Companion.toKotlin as getProvisionedProductsResultToKotlin

public object ServicecatalogFunctions {
    /**
     * This data source provides Service Catalog End User Product available to the user.[What is End User Product](https://www.alibabacloud.com/help/en/servicecatalog/latest/api-servicecatalog-2021-09-01-listproductsasenduser)
     * > **NOTE:** Available since v1.197.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.servicecatalog.getEndUserProducts({
     *     nameRegex: "ram模板创建",
     * });
     * export const alicloudServiceCatalogEndUserProductExampleId = _default.then(_default => _default.endUserProducts?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.servicecatalog.get_end_user_products(name_regex="ram模板创建")
     * pulumi.export("alicloudServiceCatalogEndUserProductExampleId", default.end_user_products[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ServiceCatalog.GetEndUserProducts.Invoke(new()
     *     {
     *         NameRegex = "ram模板创建",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudServiceCatalogEndUserProductExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getEndUserProductsResult => getEndUserProductsResult&#46;EndUserProducts[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/servicecatalog"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := servicecatalog.GetEndUserProducts(ctx, &servicecatalog.GetEndUserProductsArgs{
     * 			NameRegex: pulumi.StringRef("ram模板创建"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudServiceCatalogEndUserProductExampleId", _default.EndUserProducts[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.servicecatalog.ServicecatalogFunctions;
     * import com.pulumi.alicloud.servicecatalog.inputs.GetEndUserProductsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ServicecatalogFunctions.getEndUserProducts(GetEndUserProductsArgs.builder()
     *             .nameRegex("ram模板创建")
     *             .build());
     *         ctx.export("alicloudServiceCatalogEndUserProductExampleId", default_.endUserProducts()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:servicecatalog:getEndUserProducts
     *       Arguments:
     *         nameRegex: ram模板创建
     * outputs:
     *   alicloudServiceCatalogEndUserProductExampleId: ${default.endUserProducts[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEndUserProducts.
     * @return A collection of values returned by getEndUserProducts.
     */
    public suspend fun getEndUserProducts(argument: GetEndUserProductsPlainArgs): GetEndUserProductsResult =
        getEndUserProductsResultToKotlin(getEndUserProductsPlain(argument.toJava()).await())

    /**
     * @see [getEndUserProducts].
     * @param ids A list of End User Product IDs.
     * @param nameRegex A regex string to filter results by product name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param sortBy The field that is used to sort the queried data. The value is fixed as CreateTime, which specifies the creation time of products.
     * @param sortOrder The order in which you want to sort the queried data. Valid values: `Asc`, `Desc`.
     * @return A collection of values returned by getEndUserProducts.
     */
    public suspend fun getEndUserProducts(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        sortBy: String? = null,
        sortOrder: String? = null,
    ): GetEndUserProductsResult {
        val argument = GetEndUserProductsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            sortBy = sortBy,
            sortOrder = sortOrder,
        )
        return getEndUserProductsResultToKotlin(getEndUserProductsPlain(argument.toJava()).await())
    }

    /**
     * @see [getEndUserProducts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;servicecatalog&#46;kotlin&#46;inputs&#46;GetEndUserProductsPlainArgs].
     * @return A collection of values returned by getEndUserProducts.
     */
    public suspend fun getEndUserProducts(argument: suspend GetEndUserProductsPlainArgsBuilder.() -> Unit): GetEndUserProductsResult {
        val builder = GetEndUserProductsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEndUserProductsResultToKotlin(getEndUserProductsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Service Catalog Launch Option available to the user. [What is Launch Option](https://www.alibabacloud.com/help/en/service-catalog/developer-reference/api-servicecatalog-2021-09-01-listlaunchoptions).
     * > **NOTE:** Available since v1.196.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.servicecatalog.getEndUserProducts({
     *     nameRegex: "ram模板创建",
     * });
     * const defaultGetLaunchOptions = alicloud.servicecatalog.getLaunchOptions({
     *     productId: "data.alicloud_service_catalog_end_user_products.default.end_user_products.0.id",
     * });
     * export const alicloudServiceCatalogLaunchOptionExampleId = defaultGetLaunchOptions.then(defaultGetLaunchOptions => defaultGetLaunchOptions.launchOptions?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.servicecatalog.get_end_user_products(name_regex="ram模板创建")
     * default_get_launch_options = alicloud.servicecatalog.get_launch_options(product_id="data.alicloud_service_catalog_end_user_products.default.end_user_products.0.id")
     * pulumi.export("alicloudServiceCatalogLaunchOptionExampleId", default_get_launch_options.launch_options[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ServiceCatalog.GetEndUserProducts.Invoke(new()
     *     {
     *         NameRegex = "ram模板创建",
     *     });
     *     var defaultGetLaunchOptions = AliCloud.ServiceCatalog.GetLaunchOptions.Invoke(new()
     *     {
     *         ProductId = "data.alicloud_service_catalog_end_user_products.default.end_user_products.0.id",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudServiceCatalogLaunchOptionExampleId"] = defaultGetLaunchOptions&#46;Apply(getLaunchOptionsResult => getLaunchOptionsResult&#46;LaunchOptions[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/servicecatalog"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := servicecatalog.GetEndUserProducts(ctx, &servicecatalog.GetEndUserProductsArgs{
     * 			NameRegex: pulumi.StringRef("ram模板创建"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultGetLaunchOptions, err := servicecatalog.GetLaunchOptions(ctx, &servicecatalog.GetLaunchOptionsArgs{
     * 			ProductId: "data.alicloud_service_catalog_end_user_products.default.end_user_products.0.id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudServiceCatalogLaunchOptionExampleId", defaultGetLaunchOptions.LaunchOptions[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.servicecatalog.ServicecatalogFunctions;
     * import com.pulumi.alicloud.servicecatalog.inputs.GetEndUserProductsArgs;
     * import com.pulumi.alicloud.servicecatalog.inputs.GetLaunchOptionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ServicecatalogFunctions.getEndUserProducts(GetEndUserProductsArgs.builder()
     *             .nameRegex("ram模板创建")
     *             .build());
     *         final var defaultGetLaunchOptions = ServicecatalogFunctions.getLaunchOptions(GetLaunchOptionsArgs.builder()
     *             .productId("data.alicloud_service_catalog_end_user_products.default.end_user_products.0.id")
     *             .build());
     *         ctx.export("alicloudServiceCatalogLaunchOptionExampleId", defaultGetLaunchOptions.applyValue(getLaunchOptionsResult -> getLaunchOptionsResult.launchOptions()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:servicecatalog:getEndUserProducts
     *       Arguments:
     *         nameRegex: ram模板创建
     *   defaultGetLaunchOptions:
     *     fn::invoke:
     *       Function: alicloud:servicecatalog:getLaunchOptions
     *       Arguments:
     *         productId: data.alicloud_service_catalog_end_user_products.default.end_user_products.0.id
     * outputs:
     *   alicloudServiceCatalogLaunchOptionExampleId: ${defaultGetLaunchOptions.launchOptions[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLaunchOptions.
     * @return A collection of values returned by getLaunchOptions.
     */
    public suspend fun getLaunchOptions(argument: GetLaunchOptionsPlainArgs): GetLaunchOptionsResult =
        getLaunchOptionsResultToKotlin(getLaunchOptionsPlain(argument.toJava()).await())

    /**
     * @see [getLaunchOptions].
     * @param ids A list of Launch Option IDs.
     * @param nameRegex A regex string to filter results by portfolio name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param productId Product ID.
     * @return A collection of values returned by getLaunchOptions.
     */
    public suspend fun getLaunchOptions(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        productId: String,
    ): GetLaunchOptionsResult {
        val argument = GetLaunchOptionsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            productId = productId,
        )
        return getLaunchOptionsResultToKotlin(getLaunchOptionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getLaunchOptions].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;servicecatalog&#46;kotlin&#46;inputs&#46;GetLaunchOptionsPlainArgs].
     * @return A collection of values returned by getLaunchOptions.
     */
    public suspend fun getLaunchOptions(argument: suspend GetLaunchOptionsPlainArgsBuilder.() -> Unit): GetLaunchOptionsResult {
        val builder = GetLaunchOptionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLaunchOptionsResultToKotlin(getLaunchOptionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Service Catalog Portfolio available to the user.[What is Portfolio](https://www.alibabacloud.com/help/en/service-catalog/developer-reference/api-servicecatalog-2021-09-01-createportfolio)
     * > **NOTE:** Available in 1.204.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.servicecatalog.getPortfolios({
     *     ids: [defaultAlicloudServiceCatalogPortfolio&#46;id],
     *     nameRegex: defaultAlicloudServiceCatalogPortfolio.name,
     * });
     * export const alicloudServiceCatalogPortfolioExampleId = _default.then(_default => _default.portfolios?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.servicecatalog.get_portfolios(ids=[default_alicloud_service_catalog_portfolio["id"]],
     *     name_regex=default_alicloud_service_catalog_portfolio["name"])
     * pulumi.export("alicloudServiceCatalogPortfolioExampleId", default.portfolios[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ServiceCatalog.GetPortfolios.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultAlicloudServiceCatalogPortfolio.Id,
     *         },
     *         NameRegex = defaultAlicloudServiceCatalogPortfolio.Name,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudServiceCatalogPortfolioExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getPortfoliosResult => getPortfoliosResult&#46;Portfolios[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/servicecatalog"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _default, err := servicecatalog.GetPortfolios(ctx, &servicecatalog.GetPortfoliosArgs{
     * Ids: interface{}{
     * defaultAlicloudServiceCatalogPortfolio.Id,
     * },
     * NameRegex: pulumi.StringRef(defaultAlicloudServiceCatalogPortfolio.Name),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("alicloudServiceCatalogPortfolioExampleId", _default.Portfolios[0].Id)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.servicecatalog.ServicecatalogFunctions;
     * import com.pulumi.alicloud.servicecatalog.inputs.GetPortfoliosArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ServicecatalogFunctions.getPortfolios(GetPortfoliosArgs.builder()
     *             .ids(defaultAlicloudServiceCatalogPortfolio.id())
     *             .nameRegex(defaultAlicloudServiceCatalogPortfolio.name())
     *             .build());
     *         ctx.export("alicloudServiceCatalogPortfolioExampleId", default_.portfolios()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:servicecatalog:getPortfolios
     *       Arguments:
     *         ids:
     *           - ${defaultAlicloudServiceCatalogPortfolio.id}
     *         nameRegex: ${defaultAlicloudServiceCatalogPortfolio.name}
     * outputs:
     *   alicloudServiceCatalogPortfolioExampleId: ${default.portfolios[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPortfolios.
     * @return A collection of values returned by getPortfolios.
     */
    public suspend fun getPortfolios(argument: GetPortfoliosPlainArgs): GetPortfoliosResult =
        getPortfoliosResultToKotlin(getPortfoliosPlain(argument.toJava()).await())

    /**
     * @see [getPortfolios].
     * @param ids A list of Portfolio IDs.
     * @param nameRegex A regex string to filter results by Group Metric Rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param productId The ID of the product.
     * @param scope The query scope. Valid values: `Local`(default), `Import`, `All`.
     * @param sortBy The field that is used to sort the queried data. The value is fixed as CreateTime, which specifies the creation time of product portfolios.
     * @param sortOrder The order in which you want to sort the queried data. Valid values: `Asc`, `Desc`.
     * @return A collection of values returned by getPortfolios.
     */
    public suspend fun getPortfolios(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        productId: String? = null,
        scope: String? = null,
        sortBy: String? = null,
        sortOrder: String? = null,
    ): GetPortfoliosResult {
        val argument = GetPortfoliosPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            productId = productId,
            scope = scope,
            sortBy = sortBy,
            sortOrder = sortOrder,
        )
        return getPortfoliosResultToKotlin(getPortfoliosPlain(argument.toJava()).await())
    }

    /**
     * @see [getPortfolios].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;servicecatalog&#46;kotlin&#46;inputs&#46;GetPortfoliosPlainArgs].
     * @return A collection of values returned by getPortfolios.
     */
    public suspend fun getPortfolios(argument: suspend GetPortfoliosPlainArgsBuilder.() -> Unit): GetPortfoliosResult {
        val builder = GetPortfoliosPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPortfoliosResultToKotlin(getPortfoliosPlain(builtArgument.toJava()).await())
    }

    /**
     * > **DEPRECATED:** It has been deprecated from version `1.197.0`.
     * Please use new datasource alicloud.servicecatalog.getEndUserProducts instead.
     * This data source provides Service Catalog Product As End User available to the user.[What is Product As End User](https://www.alibabacloud.com/help/en/service-catalog/developer-reference/api-servicecatalog-2021-09-01-listproductsasenduser)
     * > **NOTE:** Available in 1.196.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.servicecatalog.getProductAsEndUsers({
     *     nameRegex: "ram模板创建",
     * });
     * export const alicloudServiceCatalogProductAsEndUserExampleId = _default.then(_default => _default.users?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.servicecatalog.get_product_as_end_users(name_regex="ram模板创建")
     * pulumi.export("alicloudServiceCatalogProductAsEndUserExampleId", default.users[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ServiceCatalog.GetProductAsEndUsers.Invoke(new()
     *     {
     *         NameRegex = "ram模板创建",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudServiceCatalogProductAsEndUserExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getProductAsEndUsersResult => getProductAsEndUsersResult&#46;Users[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/servicecatalog"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := servicecatalog.GetProductAsEndUsers(ctx, &servicecatalog.GetProductAsEndUsersArgs{
     * 			NameRegex: pulumi.StringRef("ram模板创建"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudServiceCatalogProductAsEndUserExampleId", _default.Users[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.servicecatalog.ServicecatalogFunctions;
     * import com.pulumi.alicloud.servicecatalog.inputs.GetProductAsEndUsersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ServicecatalogFunctions.getProductAsEndUsers(GetProductAsEndUsersArgs.builder()
     *             .nameRegex("ram模板创建")
     *             .build());
     *         ctx.export("alicloudServiceCatalogProductAsEndUserExampleId", default_.users()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:servicecatalog:getProductAsEndUsers
     *       Arguments:
     *         nameRegex: ram模板创建
     * outputs:
     *   alicloudServiceCatalogProductAsEndUserExampleId: ${default.users[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getProductAsEndUsers.
     * @return A collection of values returned by getProductAsEndUsers.
     */
    public suspend fun getProductAsEndUsers(argument: GetProductAsEndUsersPlainArgs): GetProductAsEndUsersResult =
        getProductAsEndUsersResultToKotlin(getProductAsEndUsersPlain(argument.toJava()).await())

    /**
     * @see [getProductAsEndUsers].
     * @param ids A list of Product As End User IDs.
     * @param nameRegex A regex string to filter results by product name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param sortBy
     * @param sortOrder
     * @return A collection of values returned by getProductAsEndUsers.
     */
    public suspend fun getProductAsEndUsers(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        sortBy: String? = null,
        sortOrder: String? = null,
    ): GetProductAsEndUsersResult {
        val argument = GetProductAsEndUsersPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            sortBy = sortBy,
            sortOrder = sortOrder,
        )
        return getProductAsEndUsersResultToKotlin(getProductAsEndUsersPlain(argument.toJava()).await())
    }

    /**
     * @see [getProductAsEndUsers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;servicecatalog&#46;kotlin&#46;inputs&#46;GetProductAsEndUsersPlainArgs].
     * @return A collection of values returned by getProductAsEndUsers.
     */
    public suspend fun getProductAsEndUsers(argument: suspend GetProductAsEndUsersPlainArgsBuilder.() -> Unit): GetProductAsEndUsersResult {
        val builder = GetProductAsEndUsersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProductAsEndUsersResultToKotlin(getProductAsEndUsersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Service Catalog Product Version available to the user.[What is Product Version](https://www.alibabacloud.com/help/en/service-catalog/developer-reference/api-servicecatalog-2021-09-01-listproductversions)
     * > **NOTE:** Available in 1.196.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.servicecatalog.getProductVersions({
     *     nameRegex: "1.0.0",
     *     productId: "prod-bp125x4k29wb7q",
     * });
     * export const alicloudServiceCatalogProductVersionExampleId = _default.then(_default => _default.productVersions?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.servicecatalog.get_product_versions(name_regex="1.0.0",
     *     product_id="prod-bp125x4k29wb7q")
     * pulumi.export("alicloudServiceCatalogProductVersionExampleId", default.product_versions[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ServiceCatalog.GetProductVersions.Invoke(new()
     *     {
     *         NameRegex = "1.0.0",
     *         ProductId = "prod-bp125x4k29wb7q",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudServiceCatalogProductVersionExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getProductVersionsResult => getProductVersionsResult&#46;ProductVersions[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/servicecatalog"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := servicecatalog.GetProductVersions(ctx, &servicecatalog.GetProductVersionsArgs{
     * 			NameRegex: pulumi.StringRef("1.0.0"),
     * 			ProductId: "prod-bp125x4k29wb7q",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudServiceCatalogProductVersionExampleId", _default.ProductVersions[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.servicecatalog.ServicecatalogFunctions;
     * import com.pulumi.alicloud.servicecatalog.inputs.GetProductVersionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ServicecatalogFunctions.getProductVersions(GetProductVersionsArgs.builder()
     *             .nameRegex("1.0.0")
     *             .productId("prod-bp125x4k29wb7q")
     *             .build());
     *         ctx.export("alicloudServiceCatalogProductVersionExampleId", default_.productVersions()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:servicecatalog:getProductVersions
     *       Arguments:
     *         nameRegex: 1.0.0
     *         productId: prod-bp125x4k29wb7q
     * outputs:
     *   alicloudServiceCatalogProductVersionExampleId: ${default.productVersions[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getProductVersions.
     * @return A collection of values returned by getProductVersions.
     */
    public suspend fun getProductVersions(argument: GetProductVersionsPlainArgs): GetProductVersionsResult =
        getProductVersionsResultToKotlin(getProductVersionsPlain(argument.toJava()).await())

    /**
     * @see [getProductVersions].
     * @param enableDetails
     * @param ids A list of Product Version IDs.
     * @param nameRegex A regex string to filter results by Group Metric Rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param productId Product ID
     * @return A collection of values returned by getProductVersions.
     */
    public suspend fun getProductVersions(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        productId: String,
    ): GetProductVersionsResult {
        val argument = GetProductVersionsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            productId = productId,
        )
        return getProductVersionsResultToKotlin(getProductVersionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getProductVersions].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;servicecatalog&#46;kotlin&#46;inputs&#46;GetProductVersionsPlainArgs].
     * @return A collection of values returned by getProductVersions.
     */
    public suspend fun getProductVersions(argument: suspend GetProductVersionsPlainArgsBuilder.() -> Unit): GetProductVersionsResult {
        val builder = GetProductVersionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProductVersionsResultToKotlin(getProductVersionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Service Catalog Provisioned Product available to the user. [What is Provisioned Product](https://www.alibabacloud.com/help/en/service-catalog/developer-reference/api-servicecatalog-2021-09-01-launchproduct)
     * > **NOTE:** Available since v1.196.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.servicecatalog.getProvisionedProducts({
     *     ids: ["IdExample"],
     *     nameRegex: "NameRegexExample",
     * });
     * export const alicloudServiceCatalogProvisionedProductExampleId = _default.then(_default => _default.provisionedProducts?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.servicecatalog.get_provisioned_products(ids=["IdExample"],
     *     name_regex="NameRegexExample")
     * pulumi.export("alicloudServiceCatalogProvisionedProductExampleId", default.provisioned_products[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ServiceCatalog.GetProvisionedProducts.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "IdExample",
     *         },
     *         NameRegex = "NameRegexExample",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudServiceCatalogProvisionedProductExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getProvisionedProductsResult => getProvisionedProductsResult&#46;ProvisionedProducts[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/servicecatalog"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := servicecatalog.GetProvisionedProducts(ctx, &servicecatalog.GetProvisionedProductsArgs{
     * 			Ids: []string{
     * 				"IdExample",
     * 			},
     * 			NameRegex: pulumi.StringRef("NameRegexExample"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudServiceCatalogProvisionedProductExampleId", _default.ProvisionedProducts[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.servicecatalog.ServicecatalogFunctions;
     * import com.pulumi.alicloud.servicecatalog.inputs.GetProvisionedProductsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ServicecatalogFunctions.getProvisionedProducts(GetProvisionedProductsArgs.builder()
     *             .ids("IdExample")
     *             .nameRegex("NameRegexExample")
     *             .build());
     *         ctx.export("alicloudServiceCatalogProvisionedProductExampleId", default_.provisionedProducts()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:servicecatalog:getProvisionedProducts
     *       Arguments:
     *         ids:
     *           - IdExample
     *         nameRegex: NameRegexExample
     * outputs:
     *   alicloudServiceCatalogProvisionedProductExampleId: ${default.provisionedProducts[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getProvisionedProducts.
     * @return A collection of values returned by getProvisionedProducts.
     */
    public suspend fun getProvisionedProducts(argument: GetProvisionedProductsPlainArgs): GetProvisionedProductsResult =
        getProvisionedProductsResultToKotlin(getProvisionedProductsPlain(argument.toJava()).await())

    /**
     * @see [getProvisionedProducts].
     * @param accessLevelFilter The access filter.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Provisioned Product IDs.
     * @param nameRegex A regex string to filter results by Product name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param sortBy The field that is used to sort the queried data.
     * @param sortOrder The sorting method.
     * @return A collection of values returned by getProvisionedProducts.
     */
    public suspend fun getProvisionedProducts(
        accessLevelFilter: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        sortBy: String? = null,
        sortOrder: String? = null,
    ): GetProvisionedProductsResult {
        val argument = GetProvisionedProductsPlainArgs(
            accessLevelFilter = accessLevelFilter,
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            sortBy = sortBy,
            sortOrder = sortOrder,
        )
        return getProvisionedProductsResultToKotlin(getProvisionedProductsPlain(argument.toJava()).await())
    }

    /**
     * @see [getProvisionedProducts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;servicecatalog&#46;kotlin&#46;inputs&#46;GetProvisionedProductsPlainArgs].
     * @return A collection of values returned by getProvisionedProducts.
     */
    public suspend fun getProvisionedProducts(argument: suspend GetProvisionedProductsPlainArgsBuilder.() -> Unit): GetProvisionedProductsResult {
        val builder = GetProvisionedProductsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProvisionedProductsResultToKotlin(getProvisionedProductsPlain(builtArgument.toJava()).await())
    }
}
