@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin.inputs

import com.pulumi.alicloud.servicecatalog.inputs.GetEndUserProductsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEndUserProducts.
 * @property ids A list of End User Product IDs.
 * @property nameRegex A regex string to filter results by product name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property sortBy The field that is used to sort the queried data. The value is fixed as CreateTime, which specifies the creation time of products.
 * @property sortOrder The order in which you want to sort the queried data. Valid values: `Asc`, `Desc`.
 */
public data class GetEndUserProductsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val sortBy: String? = null,
    public val sortOrder: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicecatalog.inputs.GetEndUserProductsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.servicecatalog.inputs.GetEndUserProductsPlainArgs =
        com.pulumi.alicloud.servicecatalog.inputs.GetEndUserProductsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .sortBy(sortBy?.let({ args0 -> args0 }))
            .sortOrder(sortOrder?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEndUserProductsPlainArgs].
 */
@PulumiTagMarker
public class GetEndUserProductsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var sortBy: String? = null

    private var sortOrder: String? = null

    /**
     * @param value A list of End User Product IDs.
     */
    @JvmName("plnsrcaisnpouulq")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of End User Product IDs.
     */
    @JvmName("tevcgnndhwnbqqmi")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by product name.
     */
    @JvmName("kdetytvwaysoqypa")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("rfpgmyyqsctaiadk")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("dsqpwmjaesuvmmtn")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("adwlppuvfigbhfgh")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The field that is used to sort the queried data. The value is fixed as CreateTime, which specifies the creation time of products.
     */
    @JvmName("kwdqskppglsdtbhi")
    public suspend fun sortBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortBy = mapped
    }

    /**
     * @param value The order in which you want to sort the queried data. Valid values: `Asc`, `Desc`.
     */
    @JvmName("fiejotsqmbwaalvl")
    public suspend fun sortOrder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortOrder = mapped
    }

    internal fun build(): GetEndUserProductsPlainArgs = GetEndUserProductsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        sortBy = sortBy,
        sortOrder = sortOrder,
    )
}
