@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin.inputs

import com.pulumi.alicloud.servicecatalog.inputs.GetPortfoliosPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPortfolios.
 * @property ids A list of Portfolio IDs.
 * @property nameRegex A regex string to filter results by Group Metric Rule name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property productId The ID of the product.
 * @property scope The query scope. Valid values: `Local`(default), `Import`, `All`.
 * @property sortBy The field that is used to sort the queried data. The value is fixed as CreateTime, which specifies the creation time of product portfolios.
 * @property sortOrder The order in which you want to sort the queried data. Valid values: `Asc`, `Desc`.
 */
public data class GetPortfoliosPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val productId: String? = null,
    public val scope: String? = null,
    public val sortBy: String? = null,
    public val sortOrder: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicecatalog.inputs.GetPortfoliosPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.servicecatalog.inputs.GetPortfoliosPlainArgs =
        com.pulumi.alicloud.servicecatalog.inputs.GetPortfoliosPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .productId(productId?.let({ args0 -> args0 }))
            .scope(scope?.let({ args0 -> args0 }))
            .sortBy(sortBy?.let({ args0 -> args0 }))
            .sortOrder(sortOrder?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPortfoliosPlainArgs].
 */
@PulumiTagMarker
public class GetPortfoliosPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var productId: String? = null

    private var scope: String? = null

    private var sortBy: String? = null

    private var sortOrder: String? = null

    /**
     * @param value A list of Portfolio IDs.
     */
    @JvmName("ythwmuyirikfumog")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Portfolio IDs.
     */
    @JvmName("dywjigceqxbyklkm")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Group Metric Rule name.
     */
    @JvmName("rmsjbkfbucplmcgi")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("kelojtrmnmyrwkjg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("xvrygxvxrjurihbs")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("asqaujtksepxcgdj")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The ID of the product.
     */
    @JvmName("nhipwrujvqmbckfy")
    public suspend fun productId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.productId = mapped
    }

    /**
     * @param value The query scope. Valid values: `Local`(default), `Import`, `All`.
     */
    @JvmName("fqsntfaciibuyvtt")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.scope = mapped
    }

    /**
     * @param value The field that is used to sort the queried data. The value is fixed as CreateTime, which specifies the creation time of product portfolios.
     */
    @JvmName("uucxvjpigqywqfqm")
    public suspend fun sortBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortBy = mapped
    }

    /**
     * @param value The order in which you want to sort the queried data. Valid values: `Asc`, `Desc`.
     */
    @JvmName("cygofsgewyxnxqwj")
    public suspend fun sortOrder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortOrder = mapped
    }

    internal fun build(): GetPortfoliosPlainArgs = GetPortfoliosPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        productId = productId,
        scope = scope,
        sortBy = sortBy,
        sortOrder = sortOrder,
    )
}
