@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin.inputs

import com.pulumi.alicloud.servicecatalog.inputs.GetProductAsEndUsersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProductAsEndUsers.
 * @property ids A list of Product As End User IDs.
 * @property nameRegex A regex string to filter results by product name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property sortBy
 * @property sortOrder
 */
public data class GetProductAsEndUsersPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val sortBy: String? = null,
    public val sortOrder: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicecatalog.inputs.GetProductAsEndUsersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.servicecatalog.inputs.GetProductAsEndUsersPlainArgs =
        com.pulumi.alicloud.servicecatalog.inputs.GetProductAsEndUsersPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .sortBy(sortBy?.let({ args0 -> args0 }))
            .sortOrder(sortOrder?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProductAsEndUsersPlainArgs].
 */
@PulumiTagMarker
public class GetProductAsEndUsersPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var sortBy: String? = null

    private var sortOrder: String? = null

    /**
     * @param value A list of Product As End User IDs.
     */
    @JvmName("tgwqrutuawpynwpp")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Product As End User IDs.
     */
    @JvmName("ofcsoyjklnostwir")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by product name.
     */
    @JvmName("kjfrmimbnevttixi")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("gbwiqdwspdjlkrii")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("yswxxmcdknulbtvb")
    public suspend fun sortBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortBy = mapped
    }

    /**
     * @param value
     */
    @JvmName("uvovpqpcsyuyvwhw")
    public suspend fun sortOrder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortOrder = mapped
    }

    internal fun build(): GetProductAsEndUsersPlainArgs = GetProductAsEndUsersPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        sortBy = sortBy,
        sortOrder = sortOrder,
    )
}
