@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin.inputs

import com.pulumi.alicloud.servicecatalog.inputs.GetProductVersionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProductVersions.
 * @property enableDetails
 * @property ids A list of Product Version IDs.
 * @property nameRegex A regex string to filter results by Group Metric Rule name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property productId Product ID
 */
public data class GetProductVersionsPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val productId: String,
) : ConvertibleToJava<com.pulumi.alicloud.servicecatalog.inputs.GetProductVersionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.servicecatalog.inputs.GetProductVersionsPlainArgs =
        com.pulumi.alicloud.servicecatalog.inputs.GetProductVersionsPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .productId(productId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProductVersionsPlainArgs].
 */
@PulumiTagMarker
public class GetProductVersionsPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var productId: String? = null

    /**
     * @param value
     */
    @JvmName("fugkjqasdkwxcwpi")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Product Version IDs.
     */
    @JvmName("utpmobjipkuyugdj")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Product Version IDs.
     */
    @JvmName("ubpuvyutvookppjc")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Group Metric Rule name.
     */
    @JvmName("yuohtbbaweidkikk")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("jomfwkvldwtrbvhf")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Product ID
     */
    @JvmName("tnpamtsrhhmntsdw")
    public suspend fun productId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.productId = mapped
    }

    internal fun build(): GetProductVersionsPlainArgs = GetProductVersionsPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        productId = productId ?: throw PulumiNullFieldException("productId"),
    )
}
