@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin.inputs

import com.pulumi.alicloud.servicecatalog.inputs.GetProvisionedProductsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProvisionedProducts.
 * @property accessLevelFilter The access filter.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Provisioned Product IDs.
 * @property nameRegex A regex string to filter results by Product name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property sortBy The field that is used to sort the queried data.
 * @property sortOrder The sorting method.
 */
public data class GetProvisionedProductsPlainArgs(
    public val accessLevelFilter: String? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val sortBy: String? = null,
    public val sortOrder: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicecatalog.inputs.GetProvisionedProductsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.servicecatalog.inputs.GetProvisionedProductsPlainArgs =
        com.pulumi.alicloud.servicecatalog.inputs.GetProvisionedProductsPlainArgs.builder()
            .accessLevelFilter(accessLevelFilter?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .sortBy(sortBy?.let({ args0 -> args0 }))
            .sortOrder(sortOrder?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProvisionedProductsPlainArgs].
 */
@PulumiTagMarker
public class GetProvisionedProductsPlainArgsBuilder internal constructor() {
    private var accessLevelFilter: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var sortBy: String? = null

    private var sortOrder: String? = null

    /**
     * @param value The access filter.
     */
    @JvmName("rlhdarivcccjstyr")
    public suspend fun accessLevelFilter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.accessLevelFilter = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("wmjpbmthktdsqlrm")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Provisioned Product IDs.
     */
    @JvmName("lhljmskngtawsoex")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Provisioned Product IDs.
     */
    @JvmName("ixaxdvbpkmngucyo")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Product name.
     */
    @JvmName("tjvmaixitatluubk")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("howsplyyctdttvat")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("eovjgcaxanmqkgby")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("uyekawovscmxjsts")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The field that is used to sort the queried data.
     */
    @JvmName("uqieosiwakymsuqd")
    public suspend fun sortBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortBy = mapped
    }

    /**
     * @param value The sorting method.
     */
    @JvmName("xuwbksxcmecnqunp")
    public suspend fun sortOrder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortOrder = mapped
    }

    internal fun build(): GetProvisionedProductsPlainArgs = GetProvisionedProductsPlainArgs(
        accessLevelFilter = accessLevelFilter,
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        sortBy = sortBy,
        sortOrder = sortOrder,
    )
}
