@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin.inputs

import com.pulumi.alicloud.servicecatalog.inputs.ProvisionedProductParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property parameterKey The name of the parameter defined in the template.
 * @property parameterValue The Template parameter value entered by the user.
 */
public data class ProvisionedProductParameterArgs(
    public val parameterKey: Output<String>? = null,
    public val parameterValue: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicecatalog.inputs.ProvisionedProductParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.servicecatalog.inputs.ProvisionedProductParameterArgs =
        com.pulumi.alicloud.servicecatalog.inputs.ProvisionedProductParameterArgs.builder()
            .parameterKey(parameterKey?.applyValue({ args0 -> args0 }))
            .parameterValue(parameterValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProvisionedProductParameterArgs].
 */
@PulumiTagMarker
public class ProvisionedProductParameterArgsBuilder internal constructor() {
    private var parameterKey: Output<String>? = null

    private var parameterValue: Output<String>? = null

    /**
     * @param value The name of the parameter defined in the template.
     */
    @JvmName("gsbngrrdktactlik")
    public suspend fun parameterKey(`value`: Output<String>) {
        this.parameterKey = value
    }

    /**
     * @param value The Template parameter value entered by the user.
     */
    @JvmName("becqvlhlaxjukfhj")
    public suspend fun parameterValue(`value`: Output<String>) {
        this.parameterValue = value
    }

    /**
     * @param value The name of the parameter defined in the template.
     */
    @JvmName("jsseqirekoilvdft")
    public suspend fun parameterKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterKey = mapped
    }

    /**
     * @param value The Template parameter value entered by the user.
     */
    @JvmName("avnfqnqmqkraxstt")
    public suspend fun parameterValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterValue = mapped
    }

    internal fun build(): ProvisionedProductParameterArgs = ProvisionedProductParameterArgs(
        parameterKey = parameterKey,
        parameterValue = parameterValue,
    )
}
