@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime Product creation time.According to ISO8601 standard, UTC time is used in the format: YYYY-MM-DDThh:mm:ssZ.
 * @property description Product description.
 * @property hasDefaultLaunchOption Whether there is a default Startup option. Value:-true: There is a default Startup option, and there is no need to fill in the portfolio when starting the product or updating the instance.-false: there is no default Startup option. You must fill in the portfolio when starting the product or updating the instance. For more information about how to obtain the portfolio, see ListLaunchOptions.> If the product is added to only one product portfolio, there will be a default Startup option. If the product is added to multiple product combinations, there will be multiple startup options at the same time, but there is no default Startup option at this time.
 * @property id ID of product, Its value is the same as `product_id`.
 * @property productArn Product ARN.
 * @property productId Product ID.
 * @property productName Product name.
 * @property productType Type of product.The value is Ros, which indicates the resource orchestration service (ROS).
 * @property providerName Product provider.
 */
public data class GetEndUserProductsEndUserProduct(
    public val createTime: String,
    public val description: String,
    public val hasDefaultLaunchOption: Boolean,
    public val id: String,
    public val productArn: String,
    public val productId: String,
    public val productName: String,
    public val productType: String,
    public val providerName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicecatalog.outputs.GetEndUserProductsEndUserProduct): GetEndUserProductsEndUserProduct = GetEndUserProductsEndUserProduct(
            createTime = javaType.createTime(),
            description = javaType.description(),
            hasDefaultLaunchOption = javaType.hasDefaultLaunchOption(),
            id = javaType.id(),
            productArn = javaType.productArn(),
            productId = javaType.productId(),
            productName = javaType.productName(),
            productType = javaType.productType(),
            providerName = javaType.providerName(),
        )
    }
}
