@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEndUserProducts.
 * @property endUserProducts A list of End User Product Entries. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of End User Product IDs.
 * @property nameRegex
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property sortBy
 * @property sortOrder
 */
public data class GetEndUserProductsResult(
    public val endUserProducts: List<GetEndUserProductsEndUserProduct>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val sortBy: String? = null,
    public val sortOrder: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicecatalog.outputs.GetEndUserProductsResult): GetEndUserProductsResult = GetEndUserProductsResult(
            endUserProducts = javaType.endUserProducts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetEndUserProductsEndUserProduct.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            sortBy = javaType.sortBy().map({ args0 -> args0 }).orElse(null),
            sortOrder = javaType.sortOrder().map({ args0 -> args0 }).orElse(null),
        )
    }
}
