@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property constraintSummaries List of constraints.
 * @property id ID of Service Catalog Launch Option.
 * @property portfolioId Product mix ID.
 * @property portfolioName Product portfolio name.
 */
public data class GetLaunchOptionsLaunchOption(
    public val constraintSummaries: List<GetLaunchOptionsLaunchOptionConstraintSummary>,
    public val id: String,
    public val portfolioId: String,
    public val portfolioName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicecatalog.outputs.GetLaunchOptionsLaunchOption): GetLaunchOptionsLaunchOption = GetLaunchOptionsLaunchOption(
            constraintSummaries = javaType.constraintSummaries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetLaunchOptionsLaunchOptionConstraintSummary.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            portfolioId = javaType.portfolioId(),
            portfolioName = javaType.portfolioName(),
        )
    }
}
