@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin.outputs

import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getLaunchOptions.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property launchOptions (Available since v1.197.0) A list of Launch Option Entries. Each element contains the following attributes:
 * @property nameRegex
 * @property options (Deprecated since v1.197.0) A list of Launch Option Entries. Each element contains the following attributes:
 * @property outputFile
 * @property productId
 */
public data class GetLaunchOptionsResult(
    public val id: String,
    public val ids: List<String>,
    public val launchOptions: List<GetLaunchOptionsLaunchOption>,
    public val nameRegex: String? = null,
    @Deprecated(
        message = """
  Field 'options' has been deprecated from provider version 1.197.0.
  """,
    )
    public val options: List<GetLaunchOptionsOption>,
    public val outputFile: String? = null,
    public val productId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicecatalog.outputs.GetLaunchOptionsResult): GetLaunchOptionsResult = GetLaunchOptionsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            launchOptions = javaType.launchOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetLaunchOptionsLaunchOption.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            options = javaType.options().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetLaunchOptionsOption.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            productId = javaType.productId(),
        )
    }
}
