@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The creation time of the portfolio
 * @property description The description of the portfolio
 * @property id The ID of the portfolio
 * @property portfolioArn The ARN of the portfolio
 * @property portfolioId The ID of the portfolio
 * @property portfolioName The name of the portfolio
 * @property providerName The provider name of the portfolio
 */
public data class GetPortfoliosPortfolio(
    public val createTime: String,
    public val description: String,
    public val id: String,
    public val portfolioArn: String,
    public val portfolioId: String,
    public val portfolioName: String,
    public val providerName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicecatalog.outputs.GetPortfoliosPortfolio): GetPortfoliosPortfolio = GetPortfoliosPortfolio(
            createTime = javaType.createTime(),
            description = javaType.description(),
            id = javaType.id(),
            portfolioArn = javaType.portfolioArn(),
            portfolioId = javaType.portfolioId(),
            portfolioName = javaType.portfolioName(),
            providerName = javaType.providerName(),
        )
    }
}
