@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPortfolios.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Portfolio IDs.
 * @property nameRegex
 * @property names A list of name of Portfolios.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property portfolios A list of Portfolio Entries. Each element contains the following attributes:
 * @property productId
 * @property scope
 * @property sortBy
 * @property sortOrder
 */
public data class GetPortfoliosResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val portfolios: List<GetPortfoliosPortfolio>,
    public val productId: String? = null,
    public val scope: String? = null,
    public val sortBy: String? = null,
    public val sortOrder: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicecatalog.outputs.GetPortfoliosResult): GetPortfoliosResult = GetPortfoliosResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            portfolios = javaType.portfolios().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetPortfoliosPortfolio.Companion.toKotlin(args0)
                })
            }),
            productId = javaType.productId().map({ args0 -> args0 }).orElse(null),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            sortBy = javaType.sortBy().map({ args0 -> args0 }).orElse(null),
            sortOrder = javaType.sortOrder().map({ args0 -> args0 }).orElse(null),
        )
    }
}
