@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProductAsEndUsers.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Product As End User IDs.
 * @property nameRegex
 * @property outputFile
 * @property sortBy
 * @property sortOrder
 * @property users A list of Product As End User Entries. Each element contains the following attributes:
 */
public data class GetProductAsEndUsersResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val sortBy: String? = null,
    public val sortOrder: String? = null,
    public val users: List<GetProductAsEndUsersUser>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicecatalog.outputs.GetProductAsEndUsersResult): GetProductAsEndUsersResult = GetProductAsEndUsersResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            sortBy = javaType.sortBy().map({ args0 -> args0 }).orElse(null),
            sortOrder = javaType.sortOrder().map({ args0 -> args0 }).orElse(null),
            users = javaType.users().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetProductAsEndUsersUser.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
