@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin.outputs

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProductVersions.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Product Version IDs.
 * @property nameRegex
 * @property names A list of name of Product Versions.
 * @property outputFile
 * @property productId
 * @property productVersions A list of Product Version Entries. Each element contains the following attributes:
 * @property versions
 */
public data class GetProductVersionsResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val productId: String,
    public val productVersions: List<GetProductVersionsProductVersion>,
    @Deprecated(
        message = """
  Field 'versions' has been deprecated from provider version 1.197.0.
  """,
    )
    public val versions: List<GetProductVersionsVersion>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicecatalog.outputs.GetProductVersionsResult): GetProductVersionsResult = GetProductVersionsResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            productId = javaType.productId(),
            productVersions = javaType.productVersions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetProductVersionsProductVersion.Companion.toKotlin(args0)
                })
            }),
            versions = javaType.versions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetProductVersionsVersion.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
