@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property active Whether the version is activated
 * @property createTime The creation time of the resource
 * @property description Version description
 * @property guidance Administrator guidance
 * @property id ID of product version.
 * @property productId Product ID
 * @property productVersionId The first ID of the resource
 * @property productVersionName The name of the resource
 * @property templateType Template Type
 * @property templateUrl Template URL
 */
public data class GetProductVersionsVersion(
    public val active: Boolean,
    public val createTime: String,
    public val description: String,
    public val guidance: String,
    public val id: String,
    public val productId: String,
    public val productVersionId: String,
    public val productVersionName: String,
    public val templateType: String,
    public val templateUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicecatalog.outputs.GetProductVersionsVersion): GetProductVersionsVersion = GetProductVersionsVersion(
            active = javaType.active(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            guidance = javaType.guidance(),
            id = javaType.id(),
            productId = javaType.productId(),
            productVersionId = javaType.productVersionId(),
            productVersionName = javaType.productVersionName(),
            templateType = javaType.templateType(),
            templateUrl = javaType.templateUrl(),
        )
    }
}
