@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property createTime The creation time of the product instance
 * @property id
 * @property lastProvisioningTaskId The ID of the last instance operation task
 * @property lastSuccessfulProvisioningTaskId The ID of the last successful instance operation task
 * @property lastTaskId The ID of the last task
 * @property outputs
 * @property ownerPrincipalId The RAM entity ID of the owner
 * @property ownerPrincipalType The RAM entity type of the owner
 * @property parameters
 * @property portfolioId Product mix ID.> When there is a default Startup option, there is no need to fill in the portfolio. When there is no default Startup option, you must fill in the portfolio.
 * @property productId Product ID.
 * @property productName The name of the product
 * @property productVersionId Product version ID.
 * @property productVersionName The name of the product version
 * @property provisionedProductArn The ARN of the product instance
 * @property provisionedProductId The ID of the instance.
 * @property provisionedProductName The name of the instance.The length is 1~128 characters.
 * @property provisionedProductType Instance type.The value is RosStack, which indicates the stack of Alibaba Cloud resource orchestration service (ROS).
 * @property stackId The ID of the ROS stack
 * @property stackRegionId The ID of the region to which the resource stack of the Alibaba Cloud resource orchestration service (ROS) belongs.
 * @property status Instance status
 * @property statusMessage The status message of the product instance
 * @property tags
 */
public data class GetProvisionedProductsProduct(
    public val createTime: String,
    public val id: String,
    public val lastProvisioningTaskId: String,
    public val lastSuccessfulProvisioningTaskId: String,
    public val lastTaskId: String,
    public val outputs: List<GetProvisionedProductsProductOutput>,
    public val ownerPrincipalId: String,
    public val ownerPrincipalType: String,
    public val parameters: List<GetProvisionedProductsProductParameter>,
    public val portfolioId: String,
    public val productId: String,
    public val productName: String,
    public val productVersionId: String,
    public val productVersionName: String,
    public val provisionedProductArn: String,
    public val provisionedProductId: String,
    public val provisionedProductName: String,
    public val provisionedProductType: String,
    public val stackId: String,
    public val stackRegionId: String,
    public val status: String,
    public val statusMessage: String,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicecatalog.outputs.GetProvisionedProductsProduct): GetProvisionedProductsProduct = GetProvisionedProductsProduct(
            createTime = javaType.createTime(),
            id = javaType.id(),
            lastProvisioningTaskId = javaType.lastProvisioningTaskId(),
            lastSuccessfulProvisioningTaskId = javaType.lastSuccessfulProvisioningTaskId(),
            lastTaskId = javaType.lastTaskId(),
            outputs = javaType.outputs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetProvisionedProductsProductOutput.Companion.toKotlin(args0)
                })
            }),
            ownerPrincipalId = javaType.ownerPrincipalId(),
            ownerPrincipalType = javaType.ownerPrincipalType(),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetProvisionedProductsProductParameter.Companion.toKotlin(args0)
                })
            }),
            portfolioId = javaType.portfolioId(),
            productId = javaType.productId(),
            productName = javaType.productName(),
            productVersionId = javaType.productVersionId(),
            productVersionName = javaType.productVersionName(),
            provisionedProductArn = javaType.provisionedProductArn(),
            provisionedProductId = javaType.provisionedProductId(),
            provisionedProductName = javaType.provisionedProductName(),
            provisionedProductType = javaType.provisionedProductType(),
            stackId = javaType.stackId(),
            stackRegionId = javaType.stackRegionId(),
            status = javaType.status(),
            statusMessage = javaType.statusMessage(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
