@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin.outputs

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProvisionedProducts.
 * @property accessLevelFilter
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Provisioned Product IDs.
 * @property nameRegex
 * @property names A list of name of Provisioned Products.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property products (Deprecated since v1.197.0) A list of Provisioned Product Entries. Each element contains the following attributes:
 * @property provisionedProducts (Available since v1.197.0) A list of Provisioned Product Entries. Each element contains the following attributes:
 * @property sortBy
 * @property sortOrder
 */
public data class GetProvisionedProductsResult(
    public val accessLevelFilter: String? = null,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    @Deprecated(
        message = """
  Field 'products' has been deprecated from provider version 1.197.0.
  """,
    )
    public val products: List<GetProvisionedProductsProduct>,
    public val provisionedProducts: List<GetProvisionedProductsProvisionedProduct>,
    public val sortBy: String? = null,
    public val sortOrder: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicecatalog.outputs.GetProvisionedProductsResult): GetProvisionedProductsResult = GetProvisionedProductsResult(
            accessLevelFilter = javaType.accessLevelFilter().map({ args0 -> args0 }).orElse(null),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            products = javaType.products().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetProvisionedProductsProduct.Companion.toKotlin(args0)
                })
            }),
            provisionedProducts = javaType.provisionedProducts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicecatalog.kotlin.outputs.GetProvisionedProductsProvisionedProduct.Companion.toKotlin(args0)
                })
            }),
            sortBy = javaType.sortBy().map({ args0 -> args0 }).orElse(null),
            sortOrder = javaType.sortOrder().map({ args0 -> args0 }).orElse(null),
        )
    }
}
