@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description Description of the output value defined in the template.
 * @property outputKey The name of the output value defined in the template.
 * @property outputValue The content of the output value defined in the template.
 */
public data class ProvisionedProductOutput(
    public val description: String? = null,
    public val outputKey: String? = null,
    public val outputValue: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicecatalog.outputs.ProvisionedProductOutput): ProvisionedProductOutput = ProvisionedProductOutput(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            outputKey = javaType.outputKey().map({ args0 -> args0 }).orElse(null),
            outputValue = javaType.outputValue().map({ args0 -> args0 }).orElse(null),
        )
    }
}
