@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicecatalog.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property parameterKey The name of the parameter defined in the template.
 * @property parameterValue The Template parameter value entered by the user.
 */
public data class ProvisionedProductParameter(
    public val parameterKey: String? = null,
    public val parameterValue: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicecatalog.outputs.ProvisionedProductParameter): ProvisionedProductParameter = ProvisionedProductParameter(
            parameterKey = javaType.parameterKey().map({ args0 -> args0 }).orElse(null),
            parameterValue = javaType.parameterValue().map({ args0 -> args0 }).orElse(null),
        )
    }
}
