@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ExtensionProvider].
 */
@PulumiTagMarker
public class ExtensionProviderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExtensionProviderArgs = ExtensionProviderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExtensionProviderArgsBuilder.() -> Unit) {
        val builder = ExtensionProviderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ExtensionProvider {
        val builtJavaResource =
            com.pulumi.alicloud.servicemesh.ExtensionProvider(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ExtensionProvider(builtJavaResource)
    }
}

/**
 * Provides a Service Mesh Extension Provider resource.
 * For information about Service Mesh Extension Provider and how to use it, see [What is Extension Provider](https://help.aliyun.com/document_detail/461549.html).
 * > **NOTE:** Available in v1.191.0+.
 * ## Import
 * Service Mesh Extension Provider can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:servicemesh/extensionProvider:ExtensionProvider example <service_mesh_id>:<type>:<extension_provider_name>
 * ```
 */
public class ExtensionProvider internal constructor(
    override val javaResource: com.pulumi.alicloud.servicemesh.ExtensionProvider,
) : KotlinCustomResource(javaResource, ExtensionProviderMapper) {
    /**
     * The config of the Service Mesh Extension Provider. The `config` format is json.
     */
    public val config: Output<String>
        get() = javaResource.config().applyValue({ args0 -> args0 })

    /**
     * The name of the Service Mesh Extension Provider. It must be prefixed with `$type-`, for example `httpextauth-xxx`, `grpcextauth-xxx`.
     */
    public val extensionProviderName: Output<String>
        get() = javaResource.extensionProviderName().applyValue({ args0 -> args0 })

    /**
     * The ID of the Service Mesh.
     */
    public val serviceMeshId: Output<String>
        get() = javaResource.serviceMeshId().applyValue({ args0 -> args0 })

    /**
     * The type of the Service Mesh Extension Provider. Valid values: `httpextauth`, `grpcextauth`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ExtensionProviderMapper : ResourceMapper<ExtensionProvider> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.servicemesh.ExtensionProvider::class == javaResource::class

    override fun map(javaResource: Resource): ExtensionProvider = ExtensionProvider(
        javaResource as
            com.pulumi.alicloud.servicemesh.ExtensionProvider,
    )
}

/**
 * @see [ExtensionProvider].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ExtensionProvider].
 */
public suspend fun extensionProvider(
    name: String,
    block: suspend ExtensionProviderResourceBuilder.() -> Unit,
): ExtensionProvider {
    val builder = ExtensionProviderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ExtensionProvider].
 * @param name The _unique_ name of the resulting resource.
 */
public fun extensionProvider(name: String): ExtensionProvider {
    val builder = ExtensionProviderResourceBuilder()
    builder.name(name)
    return builder.build()
}
