@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin

import com.pulumi.alicloud.servicemesh.ExtensionProviderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Service Mesh Extension Provider resource.
 * For information about Service Mesh Extension Provider and how to use it, see [What is Extension Provider](https://help.aliyun.com/document_detail/461549.html).
 * > **NOTE:** Available in v1.191.0+.
 * ## Import
 * Service Mesh Extension Provider can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:servicemesh/extensionProvider:ExtensionProvider example <service_mesh_id>:<type>:<extension_provider_name>
 * ```
 * @property config The config of the Service Mesh Extension Provider. The `config` format is json.
 * @property extensionProviderName The name of the Service Mesh Extension Provider. It must be prefixed with `$type-`, for example `httpextauth-xxx`, `grpcextauth-xxx`.
 * @property serviceMeshId The ID of the Service Mesh.
 * @property type The type of the Service Mesh Extension Provider. Valid values: `httpextauth`, `grpcextauth`.
 */
public data class ExtensionProviderArgs(
    public val config: Output<String>? = null,
    public val extensionProviderName: Output<String>? = null,
    public val serviceMeshId: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicemesh.ExtensionProviderArgs> {
    override fun toJava(): com.pulumi.alicloud.servicemesh.ExtensionProviderArgs =
        com.pulumi.alicloud.servicemesh.ExtensionProviderArgs.builder()
            .config(config?.applyValue({ args0 -> args0 }))
            .extensionProviderName(extensionProviderName?.applyValue({ args0 -> args0 }))
            .serviceMeshId(serviceMeshId?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExtensionProviderArgs].
 */
@PulumiTagMarker
public class ExtensionProviderArgsBuilder internal constructor() {
    private var config: Output<String>? = null

    private var extensionProviderName: Output<String>? = null

    private var serviceMeshId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The config of the Service Mesh Extension Provider. The `config` format is json.
     */
    @JvmName("sakkbrkderykvcqi")
    public suspend fun config(`value`: Output<String>) {
        this.config = value
    }

    /**
     * @param value The name of the Service Mesh Extension Provider. It must be prefixed with `$type-`, for example `httpextauth-xxx`, `grpcextauth-xxx`.
     */
    @JvmName("ftxajfdwhirilmrp")
    public suspend fun extensionProviderName(`value`: Output<String>) {
        this.extensionProviderName = value
    }

    /**
     * @param value The ID of the Service Mesh.
     */
    @JvmName("ffjjdgqtagimesnv")
    public suspend fun serviceMeshId(`value`: Output<String>) {
        this.serviceMeshId = value
    }

    /**
     * @param value The type of the Service Mesh Extension Provider. Valid values: `httpextauth`, `grpcextauth`.
     */
    @JvmName("nxidfptbndmwdqwm")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The config of the Service Mesh Extension Provider. The `config` format is json.
     */
    @JvmName("ycgdbfyuduymcvje")
    public suspend fun config(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.config = mapped
    }

    /**
     * @param value The name of the Service Mesh Extension Provider. It must be prefixed with `$type-`, for example `httpextauth-xxx`, `grpcextauth-xxx`.
     */
    @JvmName("sgpwhdcrhstismkc")
    public suspend fun extensionProviderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionProviderName = mapped
    }

    /**
     * @param value The ID of the Service Mesh.
     */
    @JvmName("yqvxyqyiffwlfqys")
    public suspend fun serviceMeshId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceMeshId = mapped
    }

    /**
     * @param value The type of the Service Mesh Extension Provider. Valid values: `httpextauth`, `grpcextauth`.
     */
    @JvmName("scwhvuapkdbhtcmq")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ExtensionProviderArgs = ExtensionProviderArgs(
        config = config,
        extensionProviderName = extensionProviderName,
        serviceMeshId = serviceMeshId,
        type = type,
    )
}
