@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin

import com.pulumi.alicloud.servicemesh.kotlin.outputs.ServiceMeshExtraConfiguration
import com.pulumi.alicloud.servicemesh.kotlin.outputs.ServiceMeshLoadBalancer
import com.pulumi.alicloud.servicemesh.kotlin.outputs.ServiceMeshMeshConfig
import com.pulumi.alicloud.servicemesh.kotlin.outputs.ServiceMeshNetwork
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.servicemesh.kotlin.outputs.ServiceMeshExtraConfiguration.Companion.toKotlin as serviceMeshExtraConfigurationToKotlin
import com.pulumi.alicloud.servicemesh.kotlin.outputs.ServiceMeshLoadBalancer.Companion.toKotlin as serviceMeshLoadBalancerToKotlin
import com.pulumi.alicloud.servicemesh.kotlin.outputs.ServiceMeshMeshConfig.Companion.toKotlin as serviceMeshMeshConfigToKotlin
import com.pulumi.alicloud.servicemesh.kotlin.outputs.ServiceMeshNetwork.Companion.toKotlin as serviceMeshNetworkToKotlin

/**
 * Builder for [ServiceMesh].
 */
@PulumiTagMarker
public class ServiceMeshResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceMeshArgs = ServiceMeshArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceMeshArgsBuilder.() -> Unit) {
        val builder = ServiceMeshArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceMesh {
        val builtJavaResource = com.pulumi.alicloud.servicemesh.ServiceMesh(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServiceMesh(builtJavaResource)
    }
}

/**
 * Provides a Service Mesh Service Mesh resource.
 * For information about Service Mesh Service Mesh and how to use it, see [What is Service Mesh](https://www.alibabacloud.com/help/en/asm/developer-reference/api-servicemesh-2020-01-11-createservicemesh).
 * > **NOTE:** Available since v1.138.0.
 * ## Import
 * Service Mesh Service Mesh can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:servicemesh/serviceMesh:ServiceMesh example <id>
 * ```
 */
public class ServiceMesh internal constructor(
    override val javaResource: com.pulumi.alicloud.servicemesh.ServiceMesh,
) : KotlinCustomResource(javaResource, ServiceMeshMapper) {
    /**
     * List of clusters.
     */
    public val clusterIds: Output<List<String>>?
        get() = javaResource.clusterIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Cluster specification. The service mesh instance specification. Valid values: `standard`,`enterprise`,`ultimate`. Default to `standard`.
     */
    public val clusterSpec: Output<String>
        get() = javaResource.clusterSpec().applyValue({ args0 -> args0 })

    /**
     * Service grid creation time.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Whether to customize Prometheus. Value:
     * -'true': custom Prometheus.
     * -'false': Do not customize Prometheus.
     * Default value: 'false '.
     */
    public val customizedPrometheus: Output<Boolean>?
        get() = javaResource.customizedPrometheus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Grid instance version type (for example: the standard, the Pro version, etc.).
     */
    public val edition: Output<String>?
        get() = javaResource.edition().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Data plane KubeAPI access capability. See `extra_configuration` below.
     */
    public val extraConfiguration: Output<ServiceMeshExtraConfiguration>
        get() = javaResource.extraConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                serviceMeshExtraConfigurationToKotlin(args0)
            })
        })

    /**
     * Whether to forcibly delete the ASM instance. Value:
     * -'true': force deletion of ASM instance
     * -'false': no forced deletion of ASM instance
     * Default value: false.
     */
    public val force: Output<Boolean>?
        get() = javaResource.force().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Load balancing information. See `load_balancer` below.
     */
    public val loadBalancer: Output<ServiceMeshLoadBalancer>
        get() = javaResource.loadBalancer().applyValue({ args0 ->
            args0.let({ args0 ->
                serviceMeshLoadBalancerToKotlin(args0)
            })
        })

    /**
     * Service grid configuration information. See `mesh_config` below.
     */
    public val meshConfig: Output<ServiceMeshMeshConfig>
        get() = javaResource.meshConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                serviceMeshMeshConfigToKotlin(args0)
            })
        })

    /**
     * Service grid network configuration information. See `network` below.
     */
    public val network: Output<ServiceMeshNetwork>
        get() = javaResource.network().applyValue({ args0 ->
            args0.let({ args0 ->
                serviceMeshNetworkToKotlin(args0)
            })
        })

    /**
     * The Prometheus service address (in non-custom cases, use the ARMS address format).
     */
    public val prometheusUrl: Output<String>?
        get() = javaResource.prometheusUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ServiceMeshName.
     */
    public val serviceMeshName: Output<String>?
        get() = javaResource.serviceMeshName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tag of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Service grid version number. The version of the resource. you can look up the version using alicloud_service_mesh_versions. Note: The version supports updating from v1.170.0, the relevant version can be obtained via istio_operator_version in `alicloud.servicemesh.getServiceMeshes`.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ServiceMeshMapper : ResourceMapper<ServiceMesh> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.servicemesh.ServiceMesh::class == javaResource::class

    override fun map(javaResource: Resource): ServiceMesh = ServiceMesh(
        javaResource as
            com.pulumi.alicloud.servicemesh.ServiceMesh,
    )
}

/**
 * @see [ServiceMesh].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceMesh].
 */
public suspend fun serviceMesh(name: String, block: suspend ServiceMeshResourceBuilder.() -> Unit): ServiceMesh {
    val builder = ServiceMeshResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceMesh].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceMesh(name: String): ServiceMesh {
    val builder = ServiceMeshResourceBuilder()
    builder.name(name)
    return builder.build()
}
