@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin

import com.pulumi.alicloud.servicemesh.ServiceMeshArgs.builder
import com.pulumi.alicloud.servicemesh.kotlin.inputs.ServiceMeshExtraConfigurationArgs
import com.pulumi.alicloud.servicemesh.kotlin.inputs.ServiceMeshExtraConfigurationArgsBuilder
import com.pulumi.alicloud.servicemesh.kotlin.inputs.ServiceMeshLoadBalancerArgs
import com.pulumi.alicloud.servicemesh.kotlin.inputs.ServiceMeshLoadBalancerArgsBuilder
import com.pulumi.alicloud.servicemesh.kotlin.inputs.ServiceMeshMeshConfigArgs
import com.pulumi.alicloud.servicemesh.kotlin.inputs.ServiceMeshMeshConfigArgsBuilder
import com.pulumi.alicloud.servicemesh.kotlin.inputs.ServiceMeshNetworkArgs
import com.pulumi.alicloud.servicemesh.kotlin.inputs.ServiceMeshNetworkArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Service Mesh Service Mesh resource.
 * For information about Service Mesh Service Mesh and how to use it, see [What is Service Mesh](https://www.alibabacloud.com/help/en/asm/developer-reference/api-servicemesh-2020-01-11-createservicemesh).
 * > **NOTE:** Available since v1.138.0.
 * ## Import
 * Service Mesh Service Mesh can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:servicemesh/serviceMesh:ServiceMesh example <id>
 * ```
 * @property clusterIds List of clusters.
 * @property clusterSpec Cluster specification. The service mesh instance specification. Valid values: `standard`,`enterprise`,`ultimate`. Default to `standard`.
 * @property customizedPrometheus Whether to customize Prometheus. Value:
 * -'true': custom Prometheus.
 * -'false': Do not customize Prometheus.
 * Default value: 'false '.
 * @property edition Grid instance version type (for example: the standard, the Pro version, etc.).
 * @property extraConfiguration Data plane KubeAPI access capability. See `extra_configuration` below.
 * @property force Whether to forcibly delete the ASM instance. Value:
 * -'true': force deletion of ASM instance
 * -'false': no forced deletion of ASM instance
 * Default value: false.
 * @property loadBalancer Load balancing information. See `load_balancer` below.
 * @property meshConfig Service grid configuration information. See `mesh_config` below.
 * @property network Service grid network configuration information. See `network` below.
 * @property prometheusUrl The Prometheus service address (in non-custom cases, use the ARMS address format).
 * @property serviceMeshName ServiceMeshName.
 * @property tags The tag of the resource.
 * @property version Service grid version number. The version of the resource. you can look up the version using alicloud_service_mesh_versions. Note: The version supports updating from v1.170.0, the relevant version can be obtained via istio_operator_version in `alicloud.servicemesh.getServiceMeshes`.
 */
public data class ServiceMeshArgs(
    public val clusterIds: Output<List<String>>? = null,
    public val clusterSpec: Output<String>? = null,
    public val customizedPrometheus: Output<Boolean>? = null,
    public val edition: Output<String>? = null,
    public val extraConfiguration: Output<ServiceMeshExtraConfigurationArgs>? = null,
    public val force: Output<Boolean>? = null,
    public val loadBalancer: Output<ServiceMeshLoadBalancerArgs>? = null,
    public val meshConfig: Output<ServiceMeshMeshConfigArgs>? = null,
    public val network: Output<ServiceMeshNetworkArgs>? = null,
    public val prometheusUrl: Output<String>? = null,
    public val serviceMeshName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicemesh.ServiceMeshArgs> {
    override fun toJava(): com.pulumi.alicloud.servicemesh.ServiceMeshArgs =
        com.pulumi.alicloud.servicemesh.ServiceMeshArgs.builder()
            .clusterIds(clusterIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .clusterSpec(clusterSpec?.applyValue({ args0 -> args0 }))
            .customizedPrometheus(customizedPrometheus?.applyValue({ args0 -> args0 }))
            .edition(edition?.applyValue({ args0 -> args0 }))
            .extraConfiguration(
                extraConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .force(force?.applyValue({ args0 -> args0 }))
            .loadBalancer(loadBalancer?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .meshConfig(meshConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .network(network?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .prometheusUrl(prometheusUrl?.applyValue({ args0 -> args0 }))
            .serviceMeshName(serviceMeshName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceMeshArgs].
 */
@PulumiTagMarker
public class ServiceMeshArgsBuilder internal constructor() {
    private var clusterIds: Output<List<String>>? = null

    private var clusterSpec: Output<String>? = null

    private var customizedPrometheus: Output<Boolean>? = null

    private var edition: Output<String>? = null

    private var extraConfiguration: Output<ServiceMeshExtraConfigurationArgs>? = null

    private var force: Output<Boolean>? = null

    private var loadBalancer: Output<ServiceMeshLoadBalancerArgs>? = null

    private var meshConfig: Output<ServiceMeshMeshConfigArgs>? = null

    private var network: Output<ServiceMeshNetworkArgs>? = null

    private var prometheusUrl: Output<String>? = null

    private var serviceMeshName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var version: Output<String>? = null

    /**
     * @param value List of clusters.
     */
    @JvmName("vidnxkxscvbehaip")
    public suspend fun clusterIds(`value`: Output<List<String>>) {
        this.clusterIds = value
    }

    @JvmName("edpydpqwleiioxsy")
    public suspend fun clusterIds(vararg values: Output<String>) {
        this.clusterIds = Output.all(values.asList())
    }

    /**
     * @param values List of clusters.
     */
    @JvmName("aioawexnqgcledgr")
    public suspend fun clusterIds(values: List<Output<String>>) {
        this.clusterIds = Output.all(values)
    }

    /**
     * @param value Cluster specification. The service mesh instance specification. Valid values: `standard`,`enterprise`,`ultimate`. Default to `standard`.
     */
    @JvmName("odxtlagcnpcugvso")
    public suspend fun clusterSpec(`value`: Output<String>) {
        this.clusterSpec = value
    }

    /**
     * @param value Whether to customize Prometheus. Value:
     * -'true': custom Prometheus.
     * -'false': Do not customize Prometheus.
     * Default value: 'false '.
     */
    @JvmName("xapboopihgnwouhl")
    public suspend fun customizedPrometheus(`value`: Output<Boolean>) {
        this.customizedPrometheus = value
    }

    /**
     * @param value Grid instance version type (for example: the standard, the Pro version, etc.).
     */
    @JvmName("xvbjdwqliupwcdvm")
    public suspend fun edition(`value`: Output<String>) {
        this.edition = value
    }

    /**
     * @param value Data plane KubeAPI access capability. See `extra_configuration` below.
     */
    @JvmName("wsftpxpcvcndfrbt")
    public suspend fun extraConfiguration(`value`: Output<ServiceMeshExtraConfigurationArgs>) {
        this.extraConfiguration = value
    }

    /**
     * @param value Whether to forcibly delete the ASM instance. Value:
     * -'true': force deletion of ASM instance
     * -'false': no forced deletion of ASM instance
     * Default value: false.
     */
    @JvmName("xhjbndarcclenaof")
    public suspend fun force(`value`: Output<Boolean>) {
        this.force = value
    }

    /**
     * @param value Load balancing information. See `load_balancer` below.
     */
    @JvmName("nyktnmijhtsugbor")
    public suspend fun loadBalancer(`value`: Output<ServiceMeshLoadBalancerArgs>) {
        this.loadBalancer = value
    }

    /**
     * @param value Service grid configuration information. See `mesh_config` below.
     */
    @JvmName("qbthraxnbrdkfcfd")
    public suspend fun meshConfig(`value`: Output<ServiceMeshMeshConfigArgs>) {
        this.meshConfig = value
    }

    /**
     * @param value Service grid network configuration information. See `network` below.
     */
    @JvmName("yyulqkfwevjgpixu")
    public suspend fun network(`value`: Output<ServiceMeshNetworkArgs>) {
        this.network = value
    }

    /**
     * @param value The Prometheus service address (in non-custom cases, use the ARMS address format).
     */
    @JvmName("tssmyxbubckjprgx")
    public suspend fun prometheusUrl(`value`: Output<String>) {
        this.prometheusUrl = value
    }

    /**
     * @param value ServiceMeshName.
     */
    @JvmName("lsecppprrvynbfpe")
    public suspend fun serviceMeshName(`value`: Output<String>) {
        this.serviceMeshName = value
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("ijfpmdjlaymerccr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Service grid version number. The version of the resource. you can look up the version using alicloud_service_mesh_versions. Note: The version supports updating from v1.170.0, the relevant version can be obtained via istio_operator_version in `alicloud.servicemesh.getServiceMeshes`.
     */
    @JvmName("fykknkofxttxylxe")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value List of clusters.
     */
    @JvmName("goeloaqebaagrlbk")
    public suspend fun clusterIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIds = mapped
    }

    /**
     * @param values List of clusters.
     */
    @JvmName("bgshbjawnubbukst")
    public suspend fun clusterIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterIds = mapped
    }

    /**
     * @param value Cluster specification. The service mesh instance specification. Valid values: `standard`,`enterprise`,`ultimate`. Default to `standard`.
     */
    @JvmName("dfyiajqrlhctenxk")
    public suspend fun clusterSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterSpec = mapped
    }

    /**
     * @param value Whether to customize Prometheus. Value:
     * -'true': custom Prometheus.
     * -'false': Do not customize Prometheus.
     * Default value: 'false '.
     */
    @JvmName("sgvvwhlvealocikb")
    public suspend fun customizedPrometheus(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customizedPrometheus = mapped
    }

    /**
     * @param value Grid instance version type (for example: the standard, the Pro version, etc.).
     */
    @JvmName("uxddtsmajjblflsu")
    public suspend fun edition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edition = mapped
    }

    /**
     * @param value Data plane KubeAPI access capability. See `extra_configuration` below.
     */
    @JvmName("boffwxxenqjnpmcm")
    public suspend fun extraConfiguration(`value`: ServiceMeshExtraConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extraConfiguration = mapped
    }

    /**
     * @param argument Data plane KubeAPI access capability. See `extra_configuration` below.
     */
    @JvmName("eppdiueulxfkakyv")
    public suspend fun extraConfiguration(argument: suspend ServiceMeshExtraConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceMeshExtraConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extraConfiguration = mapped
    }

    /**
     * @param value Whether to forcibly delete the ASM instance. Value:
     * -'true': force deletion of ASM instance
     * -'false': no forced deletion of ASM instance
     * Default value: false.
     */
    @JvmName("jtfylubtldpkimje")
    public suspend fun force(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.force = mapped
    }

    /**
     * @param value Load balancing information. See `load_balancer` below.
     */
    @JvmName("wmvqjabphxmhrkye")
    public suspend fun loadBalancer(`value`: ServiceMeshLoadBalancerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancer = mapped
    }

    /**
     * @param argument Load balancing information. See `load_balancer` below.
     */
    @JvmName("xqbffoujbckugsrl")
    public suspend fun loadBalancer(argument: suspend ServiceMeshLoadBalancerArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceMeshLoadBalancerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.loadBalancer = mapped
    }

    /**
     * @param value Service grid configuration information. See `mesh_config` below.
     */
    @JvmName("ylvmcfsuwdtsvvrf")
    public suspend fun meshConfig(`value`: ServiceMeshMeshConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.meshConfig = mapped
    }

    /**
     * @param argument Service grid configuration information. See `mesh_config` below.
     */
    @JvmName("cggxrefwmymaptfg")
    public suspend fun meshConfig(argument: suspend ServiceMeshMeshConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceMeshMeshConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.meshConfig = mapped
    }

    /**
     * @param value Service grid network configuration information. See `network` below.
     */
    @JvmName("igyrscsmkljqkwjn")
    public suspend fun network(`value`: ServiceMeshNetworkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.network = mapped
    }

    /**
     * @param argument Service grid network configuration information. See `network` below.
     */
    @JvmName("dylhyyqmptjneort")
    public suspend fun network(argument: suspend ServiceMeshNetworkArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceMeshNetworkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.network = mapped
    }

    /**
     * @param value The Prometheus service address (in non-custom cases, use the ARMS address format).
     */
    @JvmName("qbohqaybybabfbhp")
    public suspend fun prometheusUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prometheusUrl = mapped
    }

    /**
     * @param value ServiceMeshName.
     */
    @JvmName("hnuvnhavqrtmhgxx")
    public suspend fun serviceMeshName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceMeshName = mapped
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("kepgohbxdobkrpku")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag of the resource.
     */
    @JvmName("cpuvvnvmuhpiqtbi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Service grid version number. The version of the resource. you can look up the version using alicloud_service_mesh_versions. Note: The version supports updating from v1.170.0, the relevant version can be obtained via istio_operator_version in `alicloud.servicemesh.getServiceMeshes`.
     */
    @JvmName("lkbksmdxabmqgvds")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ServiceMeshArgs = ServiceMeshArgs(
        clusterIds = clusterIds,
        clusterSpec = clusterSpec,
        customizedPrometheus = customizedPrometheus,
        edition = edition,
        extraConfiguration = extraConfiguration,
        force = force,
        loadBalancer = loadBalancer,
        meshConfig = meshConfig,
        network = network,
        prometheusUrl = prometheusUrl,
        serviceMeshName = serviceMeshName,
        tags = tags,
        version = version,
    )
}
