@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin

import com.pulumi.alicloud.servicemesh.ServicemeshFunctions.getExtensionProvidersPlain
import com.pulumi.alicloud.servicemesh.ServicemeshFunctions.getServiceMeshesPlain
import com.pulumi.alicloud.servicemesh.ServicemeshFunctions.getVersionsPlain
import com.pulumi.alicloud.servicemesh.kotlin.inputs.GetExtensionProvidersPlainArgs
import com.pulumi.alicloud.servicemesh.kotlin.inputs.GetExtensionProvidersPlainArgsBuilder
import com.pulumi.alicloud.servicemesh.kotlin.inputs.GetServiceMeshesPlainArgs
import com.pulumi.alicloud.servicemesh.kotlin.inputs.GetServiceMeshesPlainArgsBuilder
import com.pulumi.alicloud.servicemesh.kotlin.inputs.GetVersionsPlainArgs
import com.pulumi.alicloud.servicemesh.kotlin.inputs.GetVersionsPlainArgsBuilder
import com.pulumi.alicloud.servicemesh.kotlin.outputs.GetExtensionProvidersResult
import com.pulumi.alicloud.servicemesh.kotlin.outputs.GetServiceMeshesResult
import com.pulumi.alicloud.servicemesh.kotlin.outputs.GetVersionsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.servicemesh.kotlin.outputs.GetExtensionProvidersResult.Companion.toKotlin as getExtensionProvidersResultToKotlin
import com.pulumi.alicloud.servicemesh.kotlin.outputs.GetServiceMeshesResult.Companion.toKotlin as getServiceMeshesResultToKotlin
import com.pulumi.alicloud.servicemesh.kotlin.outputs.GetVersionsResult.Companion.toKotlin as getVersionsResultToKotlin

public object ServicemeshFunctions {
    /**
     * This data source provides the Service Mesh Extension Providers of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.191.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.servicemesh.getExtensionProviders({
     *     ids: ["example_id"],
     *     serviceMeshId: "example_service_mesh_id",
     *     type: "httpextauth",
     * });
     * export const serviceMeshExtensionProvidersId1 = ids.then(ids => ids.providers?.[0]?.id);
     * const nameRegex = alicloud.servicemesh.getExtensionProviders({
     *     nameRegex: "^my-ServiceMeshExtensionProvider",
     *     serviceMeshId: "example_service_mesh_id",
     *     type: "httpextauth",
     * });
     * export const serviceMeshExtensionProvidersId2 = nameRegex.then(nameRegex => nameRegex.providers?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.servicemesh.get_extension_providers(ids=["example_id"],
     *     service_mesh_id="example_service_mesh_id",
     *     type="httpextauth")
     * pulumi.export("serviceMeshExtensionProvidersId1", ids.providers[0].id)
     * name_regex = alicloud.servicemesh.get_extension_providers(name_regex="^my-ServiceMeshExtensionProvider",
     *     service_mesh_id="example_service_mesh_id",
     *     type="httpextauth")
     * pulumi.export("serviceMeshExtensionProvidersId2", name_regex.providers[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.ServiceMesh.GetExtensionProviders.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         ServiceMeshId = "example_service_mesh_id",
     *         Type = "httpextauth",
     *     });
     *     var nameRegex = AliCloud.ServiceMesh.GetExtensionProviders.Invoke(new()
     *     {
     *         NameRegex = "^my-ServiceMeshExtensionProvider",
     *         ServiceMeshId = "example_service_mesh_id",
     *         Type = "httpextauth",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["serviceMeshExtensionProvidersId1"] = ids&#46;Apply(getExtensionProvidersResult => getExtensionProvidersResult&#46;Providers[0]?.Id),
     *         ["serviceMeshExtensionProvidersId2"] = nameRegex&#46;Apply(getExtensionProvidersResult => getExtensionProvidersResult&#46;Providers[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/servicemesh"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := servicemesh.GetExtensionProviders(ctx, &servicemesh.GetExtensionProvidersArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			ServiceMeshId: "example_service_mesh_id",
     * 			Type:          "httpextauth",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("serviceMeshExtensionProvidersId1", ids.Providers[0].Id)
     * 		nameRegex, err := servicemesh.GetExtensionProviders(ctx, &servicemesh.GetExtensionProvidersArgs{
     * 			NameRegex:     pulumi.StringRef("^my-ServiceMeshExtensionProvider"),
     * 			ServiceMeshId: "example_service_mesh_id",
     * 			Type:          "httpextauth",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("serviceMeshExtensionProvidersId2", nameRegex.Providers[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.servicemesh.ServicemeshFunctions;
     * import com.pulumi.alicloud.servicemesh.inputs.GetExtensionProvidersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = ServicemeshFunctions.getExtensionProviders(GetExtensionProvidersArgs.builder()
     *             .ids("example_id")
     *             .serviceMeshId("example_service_mesh_id")
     *             .type("httpextauth")
     *             .build());
     *         ctx.export("serviceMeshExtensionProvidersId1", ids.applyValue(getExtensionProvidersResult -> getExtensionProvidersResult.providers()[0].id()));
     *         final var nameRegex = ServicemeshFunctions.getExtensionProviders(GetExtensionProvidersArgs.builder()
     *             .nameRegex("^my-ServiceMeshExtensionProvider")
     *             .serviceMeshId("example_service_mesh_id")
     *             .type("httpextauth")
     *             .build());
     *         ctx.export("serviceMeshExtensionProvidersId2", nameRegex.applyValue(getExtensionProvidersResult -> getExtensionProvidersResult.providers()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:servicemesh:getExtensionProviders
     *       Arguments:
     *         ids:
     *           - example_id
     *         serviceMeshId: example_service_mesh_id
     *         type: httpextauth
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:servicemesh:getExtensionProviders
     *       Arguments:
     *         nameRegex: ^my-ServiceMeshExtensionProvider
     *         serviceMeshId: example_service_mesh_id
     *         type: httpextauth
     * outputs:
     *   serviceMeshExtensionProvidersId1: ${ids.providers[0].id}
     *   serviceMeshExtensionProvidersId2: ${nameRegex.providers[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getExtensionProviders.
     * @return A collection of values returned by getExtensionProviders.
     */
    public suspend fun getExtensionProviders(argument: GetExtensionProvidersPlainArgs): GetExtensionProvidersResult =
        getExtensionProvidersResultToKotlin(getExtensionProvidersPlain(argument.toJava()).await())

    /**
     * @see [getExtensionProviders].
     * @param ids A list of Service Mesh Extension Provider IDs.
     * @param nameRegex A regex string to filter results by Service Mesh Extension Provider name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param serviceMeshId The ID of the Service Mesh.
     * @param type The type of the Service Mesh Extension Provider. Valid values: `httpextauth`, `grpcextauth`.
     * @return A collection of values returned by getExtensionProviders.
     */
    public suspend fun getExtensionProviders(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        serviceMeshId: String,
        type: String,
    ): GetExtensionProvidersResult {
        val argument = GetExtensionProvidersPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            serviceMeshId = serviceMeshId,
            type = type,
        )
        return getExtensionProvidersResultToKotlin(getExtensionProvidersPlain(argument.toJava()).await())
    }

    /**
     * @see [getExtensionProviders].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;servicemesh&#46;kotlin&#46;inputs&#46;GetExtensionProvidersPlainArgs].
     * @return A collection of values returned by getExtensionProviders.
     */
    public suspend fun getExtensionProviders(argument: suspend GetExtensionProvidersPlainArgsBuilder.() -> Unit): GetExtensionProvidersResult {
        val builder = GetExtensionProvidersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExtensionProvidersResultToKotlin(getExtensionProvidersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Service Mesh Service Meshes of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.138.0.
     * @param argument A collection of arguments for invoking getServiceMeshes.
     * @return A collection of values returned by getServiceMeshes.
     */
    public suspend fun getServiceMeshes(argument: GetServiceMeshesPlainArgs): GetServiceMeshesResult =
        getServiceMeshesResultToKotlin(getServiceMeshesPlain(argument.toJava()).await())

    /**
     * @see [getServiceMeshes].
     * @param enableDetails Whether to query the detailed list of resource attributes. Default value: `false`.
     * @param ids A list of Service Mesh IDs.
     * @param nameRegex A regex string to filter results by Service Mesh name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the Service Mesh. Valid values: `running`, `initial`.
     * @return A collection of values returned by getServiceMeshes.
     */
    public suspend fun getServiceMeshes(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetServiceMeshesResult {
        val argument = GetServiceMeshesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getServiceMeshesResultToKotlin(getServiceMeshesPlain(argument.toJava()).await())
    }

    /**
     * @see [getServiceMeshes].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;servicemesh&#46;kotlin&#46;inputs&#46;GetServiceMeshesPlainArgs].
     * @return A collection of values returned by getServiceMeshes.
     */
    public suspend fun getServiceMeshes(argument: suspend GetServiceMeshesPlainArgsBuilder.() -> Unit): GetServiceMeshesResult {
        val builder = GetServiceMeshesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceMeshesResultToKotlin(getServiceMeshesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides ASM available versions in the specified region.
     * > **NOTE:** Available in v1.161.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.servicemesh.getVersions({
     *     edition: "Default",
     * });
     * export const serviceMeshVersion = versions[0].version;
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.servicemesh.get_versions(edition="Default")
     * pulumi.export("serviceMeshVersion", versions[0]["version"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ServiceMesh.GetVersions.Invoke(new()
     *     {
     *         Edition = "Default",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["serviceMeshVersion"] = versions[0].Version,
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/servicemesh"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := servicemesh.GetVersions(ctx, &servicemesh.GetVersionsArgs{
     * 			Edition: pulumi.StringRef("Default"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("serviceMeshVersion", versions[0].Version)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.servicemesh.ServicemeshFunctions;
     * import com.pulumi.alicloud.servicemesh.inputs.GetVersionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ServicemeshFunctions.getVersions(GetVersionsArgs.builder()
     *             .edition("Default")
     *             .build());
     *         ctx.export("serviceMeshVersion", versions[0].version());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:servicemesh:getVersions
     *       Arguments:
     *         edition: Default
     * outputs:
     *   serviceMeshVersion: ${versions[0].version}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVersions.
     * @return A collection of values returned by getVersions.
     */
    public suspend fun getVersions(argument: GetVersionsPlainArgs): GetVersionsResult =
        getVersionsResultToKotlin(getVersionsPlain(argument.toJava()).await())

    /**
     * @see [getVersions].
     * @param edition The edition of the ASM instance. Valid values:
     * - Default: Standard Edition
     * - Pro: Professional Edition
     * @param ids A list of ASM versions. Its element formats as `<edition>:<version>`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getVersions.
     */
    public suspend fun getVersions(
        edition: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
    ): GetVersionsResult {
        val argument = GetVersionsPlainArgs(
            edition = edition,
            ids = ids,
            outputFile = outputFile,
        )
        return getVersionsResultToKotlin(getVersionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVersions].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;servicemesh&#46;kotlin&#46;inputs&#46;GetVersionsPlainArgs].
     * @return A collection of values returned by getVersions.
     */
    public suspend fun getVersions(argument: suspend GetVersionsPlainArgsBuilder.() -> Unit): GetVersionsResult {
        val builder = GetVersionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVersionsResultToKotlin(getVersionsPlain(builtArgument.toJava()).await())
    }
}
