@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin

import com.pulumi.alicloud.servicemesh.kotlin.outputs.UserPermissionPermission
import com.pulumi.alicloud.servicemesh.kotlin.outputs.UserPermissionPermission.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [UserPermission].
 */
@PulumiTagMarker
public class UserPermissionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserPermissionArgs = UserPermissionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserPermissionArgsBuilder.() -> Unit) {
        val builder = UserPermissionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UserPermission {
        val builtJavaResource = com.pulumi.alicloud.servicemesh.UserPermission(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserPermission(builtJavaResource)
    }
}

/**
 * Provides a Service Mesh UserPermission resource.
 * For information about Service Mesh User Permission and how to use it, see [What is User Permission](https://www.alibabacloud.com/help/en/alibaba-cloud-service-mesh/latest/api-servicemesh-2020-01-11-grantuserpermissions).
 * > **NOTE:** Available since v1.174.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.servicemesh.ServicemeshFunctions;
 * import com.pulumi.alicloud.servicemesh.inputs.GetVersionsArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.ram.User;
 * import com.pulumi.alicloud.ram.UserArgs;
 * import com.pulumi.alicloud.servicemesh.ServiceMesh;
 * import com.pulumi.alicloud.servicemesh.ServiceMeshArgs;
 * import com.pulumi.alicloud.servicemesh.inputs.ServiceMeshNetworkArgs;
 * import com.pulumi.alicloud.servicemesh.inputs.ServiceMeshLoadBalancerArgs;
 * import com.pulumi.alicloud.servicemesh.UserPermission;
 * import com.pulumi.alicloud.servicemesh.UserPermissionArgs;
 * import com.pulumi.alicloud.servicemesh.inputs.UserPermissionPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexample");
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var default = ServicemeshFunctions.getVersions(GetVersionsArgs.builder()
 *             .edition("Default")
 *             .build());
 *         final var defaultGetZones = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .build());
 *         var defaultUser = new User("defaultUser", UserArgs.builder()
 *             .name(name)
 *             .build());
 *         var default1 = new ServiceMesh("default1", ServiceMeshArgs.builder()
 *             .serviceMeshName(String.format("%s-%s", name,defaultInteger.result()))
 *             .edition("Default")
 *             .clusterSpec("standard")
 *             .version(default_.versions()[0].version())
 *             .network(ServiceMeshNetworkArgs.builder()
 *                 .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *                 .vswitcheLists(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *                 .build())
 *             .loadBalancer(ServiceMeshLoadBalancerArgs.builder()
 *                 .pilotPublicEip(false)
 *                 .apiServerPublicEip(false)
 *                 .build())
 *             .build());
 *         var defaultUserPermission = new UserPermission("defaultUserPermission", UserPermissionArgs.builder()
 *             .subAccountUserId(defaultUser.id())
 *             .permissions(UserPermissionPermissionArgs.builder()
 *                 .roleName("istio-ops")
 *                 .serviceMeshId(default1.id())
 *                 .roleType("custom")
 *                 .isCustom(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultUser:
 *     type: alicloud:ram:User
 *     name: default
 *     properties:
 *       name: ${name}
 *   default1:
 *     type: alicloud:servicemesh:ServiceMesh
 *     properties:
 *       serviceMeshName: ${name}-${defaultInteger.result}
 *       edition: Default
 *       clusterSpec: standard
 *       version: ${default.versions[0].version}
 *       network:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         vswitcheLists:
 *           - ${defaultGetSwitches.ids[0]}
 *       loadBalancer:
 *         pilotPublicEip: false
 *         apiServerPublicEip: false
 *   defaultUserPermission:
 *     type: alicloud:servicemesh:UserPermission
 *     name: default
 *     properties:
 *       subAccountUserId: ${defaultUser.id}
 *       permissions:
 *         - roleName: istio-ops
 *           serviceMeshId: ${default1.id}
 *           roleType: custom
 *           isCustom: true
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:servicemesh:getVersions
 *       Arguments:
 *         edition: Default
 *   defaultGetZones:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${defaultGetZones.zones[0].id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Service Mesh User Permission can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:servicemesh/userPermission:UserPermission example <id>
 * ```
 */
public class UserPermission internal constructor(
    override val javaResource: com.pulumi.alicloud.servicemesh.UserPermission,
) : KotlinCustomResource(javaResource, UserPermissionMapper) {
    /**
     * List of permissions. **Warning:** The list requires the full amount of permission information to be passed. Adding permissions means adding items to the list, and deleting them or inputting nothing means removing items. See `permissions` below.
     */
    public val permissions: Output<List<UserPermissionPermission>>
        get() = javaResource.permissions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The configuration of the Load Balancer. See the following `Block load_balancer`.
     */
    public val subAccountUserId: Output<String>
        get() = javaResource.subAccountUserId().applyValue({ args0 -> args0 })
}

public object UserPermissionMapper : ResourceMapper<UserPermission> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.servicemesh.UserPermission::class == javaResource::class

    override fun map(javaResource: Resource): UserPermission = UserPermission(
        javaResource as
            com.pulumi.alicloud.servicemesh.UserPermission,
    )
}

/**
 * @see [UserPermission].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserPermission].
 */
public suspend fun userPermission(
    name: String,
    block: suspend UserPermissionResourceBuilder.() -> Unit,
): UserPermission {
    val builder = UserPermissionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserPermission].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userPermission(name: String): UserPermission {
    val builder = UserPermissionResourceBuilder()
    builder.name(name)
    return builder.build()
}
