@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin

import com.pulumi.alicloud.servicemesh.UserPermissionArgs.builder
import com.pulumi.alicloud.servicemesh.kotlin.inputs.UserPermissionPermissionArgs
import com.pulumi.alicloud.servicemesh.kotlin.inputs.UserPermissionPermissionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Service Mesh UserPermission resource.
 * For information about Service Mesh User Permission and how to use it, see [What is User Permission](https://www.alibabacloud.com/help/en/alibaba-cloud-service-mesh/latest/api-servicemesh-2020-01-11-grantuserpermissions).
 * > **NOTE:** Available since v1.174.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.servicemesh.ServicemeshFunctions;
 * import com.pulumi.alicloud.servicemesh.inputs.GetVersionsArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.ram.User;
 * import com.pulumi.alicloud.ram.UserArgs;
 * import com.pulumi.alicloud.servicemesh.ServiceMesh;
 * import com.pulumi.alicloud.servicemesh.ServiceMeshArgs;
 * import com.pulumi.alicloud.servicemesh.inputs.ServiceMeshNetworkArgs;
 * import com.pulumi.alicloud.servicemesh.inputs.ServiceMeshLoadBalancerArgs;
 * import com.pulumi.alicloud.servicemesh.UserPermission;
 * import com.pulumi.alicloud.servicemesh.UserPermissionArgs;
 * import com.pulumi.alicloud.servicemesh.inputs.UserPermissionPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexample");
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var default = ServicemeshFunctions.getVersions(GetVersionsArgs.builder()
 *             .edition("Default")
 *             .build());
 *         final var defaultGetZones = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .build());
 *         var defaultUser = new User("defaultUser", UserArgs.builder()
 *             .name(name)
 *             .build());
 *         var default1 = new ServiceMesh("default1", ServiceMeshArgs.builder()
 *             .serviceMeshName(String.format("%s-%s", name,defaultInteger.result()))
 *             .edition("Default")
 *             .clusterSpec("standard")
 *             .version(default_.versions()[0].version())
 *             .network(ServiceMeshNetworkArgs.builder()
 *                 .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *                 .vswitcheLists(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *                 .build())
 *             .loadBalancer(ServiceMeshLoadBalancerArgs.builder()
 *                 .pilotPublicEip(false)
 *                 .apiServerPublicEip(false)
 *                 .build())
 *             .build());
 *         var defaultUserPermission = new UserPermission("defaultUserPermission", UserPermissionArgs.builder()
 *             .subAccountUserId(defaultUser.id())
 *             .permissions(UserPermissionPermissionArgs.builder()
 *                 .roleName("istio-ops")
 *                 .serviceMeshId(default1.id())
 *                 .roleType("custom")
 *                 .isCustom(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultUser:
 *     type: alicloud:ram:User
 *     name: default
 *     properties:
 *       name: ${name}
 *   default1:
 *     type: alicloud:servicemesh:ServiceMesh
 *     properties:
 *       serviceMeshName: ${name}-${defaultInteger.result}
 *       edition: Default
 *       clusterSpec: standard
 *       version: ${default.versions[0].version}
 *       network:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         vswitcheLists:
 *           - ${defaultGetSwitches.ids[0]}
 *       loadBalancer:
 *         pilotPublicEip: false
 *         apiServerPublicEip: false
 *   defaultUserPermission:
 *     type: alicloud:servicemesh:UserPermission
 *     name: default
 *     properties:
 *       subAccountUserId: ${defaultUser.id}
 *       permissions:
 *         - roleName: istio-ops
 *           serviceMeshId: ${default1.id}
 *           roleType: custom
 *           isCustom: true
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:servicemesh:getVersions
 *       Arguments:
 *         edition: Default
 *   defaultGetZones:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${defaultGetZones.zones[0].id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Service Mesh User Permission can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:servicemesh/userPermission:UserPermission example <id>
 * ```
 * @property permissions List of permissions. **Warning:** The list requires the full amount of permission information to be passed. Adding permissions means adding items to the list, and deleting them or inputting nothing means removing items. See `permissions` below.
 * @property subAccountUserId The configuration of the Load Balancer. See the following `Block load_balancer`.
 */
public data class UserPermissionArgs(
    public val permissions: Output<List<UserPermissionPermissionArgs>>? = null,
    public val subAccountUserId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicemesh.UserPermissionArgs> {
    override fun toJava(): com.pulumi.alicloud.servicemesh.UserPermissionArgs =
        com.pulumi.alicloud.servicemesh.UserPermissionArgs.builder()
            .permissions(
                permissions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .subAccountUserId(subAccountUserId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPermissionArgs].
 */
@PulumiTagMarker
public class UserPermissionArgsBuilder internal constructor() {
    private var permissions: Output<List<UserPermissionPermissionArgs>>? = null

    private var subAccountUserId: Output<String>? = null

    /**
     * @param value List of permissions. **Warning:** The list requires the full amount of permission information to be passed. Adding permissions means adding items to the list, and deleting them or inputting nothing means removing items. See `permissions` below.
     */
    @JvmName("guwvwqgylnoprrqw")
    public suspend fun permissions(`value`: Output<List<UserPermissionPermissionArgs>>) {
        this.permissions = value
    }

    @JvmName("laskbksvapoxoinv")
    public suspend fun permissions(vararg values: Output<UserPermissionPermissionArgs>) {
        this.permissions = Output.all(values.asList())
    }

    /**
     * @param values List of permissions. **Warning:** The list requires the full amount of permission information to be passed. Adding permissions means adding items to the list, and deleting them or inputting nothing means removing items. See `permissions` below.
     */
    @JvmName("fgqsofjukdbvtbsg")
    public suspend fun permissions(values: List<Output<UserPermissionPermissionArgs>>) {
        this.permissions = Output.all(values)
    }

    /**
     * @param value The configuration of the Load Balancer. See the following `Block load_balancer`.
     */
    @JvmName("xyckhmilrqwxkkrh")
    public suspend fun subAccountUserId(`value`: Output<String>) {
        this.subAccountUserId = value
    }

    /**
     * @param value List of permissions. **Warning:** The list requires the full amount of permission information to be passed. Adding permissions means adding items to the list, and deleting them or inputting nothing means removing items. See `permissions` below.
     */
    @JvmName("hgrafikbnjubjcpl")
    public suspend fun permissions(`value`: List<UserPermissionPermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param argument List of permissions. **Warning:** The list requires the full amount of permission information to be passed. Adding permissions means adding items to the list, and deleting them or inputting nothing means removing items. See `permissions` below.
     */
    @JvmName("eyhiyejxkajblosw")
    public suspend fun permissions(argument: List<suspend UserPermissionPermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserPermissionPermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument List of permissions. **Warning:** The list requires the full amount of permission information to be passed. Adding permissions means adding items to the list, and deleting them or inputting nothing means removing items. See `permissions` below.
     */
    @JvmName("dshrewnjwtxjskoc")
    public suspend fun permissions(vararg argument: suspend UserPermissionPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserPermissionPermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument List of permissions. **Warning:** The list requires the full amount of permission information to be passed. Adding permissions means adding items to the list, and deleting them or inputting nothing means removing items. See `permissions` below.
     */
    @JvmName("ucdseeoaejqtngxn")
    public suspend fun permissions(argument: suspend UserPermissionPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            UserPermissionPermissionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param values List of permissions. **Warning:** The list requires the full amount of permission information to be passed. Adding permissions means adding items to the list, and deleting them or inputting nothing means removing items. See `permissions` below.
     */
    @JvmName("jkrdaluwuywskoeh")
    public suspend fun permissions(vararg values: UserPermissionPermissionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value The configuration of the Load Balancer. See the following `Block load_balancer`.
     */
    @JvmName("rtmhbpuxuoaonshx")
    public suspend fun subAccountUserId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subAccountUserId = mapped
    }

    internal fun build(): UserPermissionArgs = UserPermissionArgs(
        permissions = permissions,
        subAccountUserId = subAccountUserId,
    )
}
