@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.inputs

import com.pulumi.alicloud.servicemesh.inputs.GetExtensionProvidersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getExtensionProviders.
 * @property ids A list of Service Mesh Extension Provider IDs.
 * @property nameRegex A regex string to filter results by Service Mesh Extension Provider name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property serviceMeshId The ID of the Service Mesh.
 * @property type The type of the Service Mesh Extension Provider. Valid values: `httpextauth`, `grpcextauth`.
 */
public data class GetExtensionProvidersPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val serviceMeshId: String,
    public val type: String,
) : ConvertibleToJava<com.pulumi.alicloud.servicemesh.inputs.GetExtensionProvidersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.servicemesh.inputs.GetExtensionProvidersPlainArgs =
        com.pulumi.alicloud.servicemesh.inputs.GetExtensionProvidersPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .serviceMeshId(serviceMeshId.let({ args0 -> args0 }))
            .type(type.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExtensionProvidersPlainArgs].
 */
@PulumiTagMarker
public class GetExtensionProvidersPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var serviceMeshId: String? = null

    private var type: String? = null

    /**
     * @param value A list of Service Mesh Extension Provider IDs.
     */
    @JvmName("rwdbfnxnnetrbjsb")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Service Mesh Extension Provider IDs.
     */
    @JvmName("gmehebncejkovgwt")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Service Mesh Extension Provider name.
     */
    @JvmName("aeucvohtruickbbf")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("hurvantapspdatqa")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the Service Mesh.
     */
    @JvmName("jtbvoscvhaqpqyhg")
    public suspend fun serviceMeshId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceMeshId = mapped
    }

    /**
     * @param value The type of the Service Mesh Extension Provider. Valid values: `httpextauth`, `grpcextauth`.
     */
    @JvmName("saawwboqcrikvwce")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetExtensionProvidersPlainArgs = GetExtensionProvidersPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        serviceMeshId = serviceMeshId ?: throw PulumiNullFieldException("serviceMeshId"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
