@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.inputs

import com.pulumi.alicloud.servicemesh.inputs.GetServiceMeshesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServiceMeshes.
 * @property enableDetails Whether to query the detailed list of resource attributes. Default value: `false`.
 * @property ids A list of Service Mesh IDs.
 * @property nameRegex A regex string to filter results by Service Mesh name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the Service Mesh. Valid values: `running`, `initial`.
 */
public data class GetServiceMeshesPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicemesh.inputs.GetServiceMeshesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.servicemesh.inputs.GetServiceMeshesPlainArgs =
        com.pulumi.alicloud.servicemesh.inputs.GetServiceMeshesPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServiceMeshesPlainArgs].
 */
@PulumiTagMarker
public class GetServiceMeshesPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value Whether to query the detailed list of resource attributes. Default value: `false`.
     */
    @JvmName("gvtkqssarwmjgatr")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Service Mesh IDs.
     */
    @JvmName("irkbyyaqogplcsix")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Service Mesh IDs.
     */
    @JvmName("yuxginxopqfukxig")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Service Mesh name.
     */
    @JvmName("wcgmefijwtxhiaev")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("scdsswypvwdawpsd")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the Service Mesh. Valid values: `running`, `initial`.
     */
    @JvmName("edvoooxpsjvbmvso")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetServiceMeshesPlainArgs = GetServiceMeshesPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
