@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.inputs

import com.pulumi.alicloud.servicemesh.inputs.GetVersionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVersions.
 * @property edition The edition of the ASM instance. Valid values:
 * - Default: Standard Edition
 * - Pro: Professional Edition
 * @property ids A list of ASM versions. Its element formats as `<edition>:<version>`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetVersionsPlainArgs(
    public val edition: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicemesh.inputs.GetVersionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.servicemesh.inputs.GetVersionsPlainArgs =
        com.pulumi.alicloud.servicemesh.inputs.GetVersionsPlainArgs.builder()
            .edition(edition?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVersionsPlainArgs].
 */
@PulumiTagMarker
public class GetVersionsPlainArgsBuilder internal constructor() {
    private var edition: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    /**
     * @param value The edition of the ASM instance. Valid values:
     * - Default: Standard Edition
     * - Pro: Professional Edition
     */
    @JvmName("tjukovbfvcxhomvq")
    public suspend fun edition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.edition = mapped
    }

    /**
     * @param value A list of ASM versions. Its element formats as `<edition>:<version>`.
     */
    @JvmName("sqplopiqyanbtbxm")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of ASM versions. Its element formats as `<edition>:<version>`.
     */
    @JvmName("sjwbwytodxhtvfuf")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("nvgmkeeofqjqgjog")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetVersionsPlainArgs = GetVersionsPlainArgs(
        edition = edition,
        ids = ids,
        outputFile = outputFile,
    )
}
