@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.inputs

import com.pulumi.alicloud.servicemesh.inputs.ServiceMeshExtraConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property crAggregationEnabled Whether the data plane KubeAPI access capability is enabled. Indicates whether the Kubernetes API of clusters on the data plane is used to access Istio resources. A value of true indicates that the Kubernetes API is used.
 */
public data class ServiceMeshExtraConfigurationArgs(
    public val crAggregationEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicemesh.inputs.ServiceMeshExtraConfigurationArgs> {
    override fun toJava(): com.pulumi.alicloud.servicemesh.inputs.ServiceMeshExtraConfigurationArgs =
        com.pulumi.alicloud.servicemesh.inputs.ServiceMeshExtraConfigurationArgs.builder()
            .crAggregationEnabled(crAggregationEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceMeshExtraConfigurationArgs].
 */
@PulumiTagMarker
public class ServiceMeshExtraConfigurationArgsBuilder internal constructor() {
    private var crAggregationEnabled: Output<Boolean>? = null

    /**
     * @param value Whether the data plane KubeAPI access capability is enabled. Indicates whether the Kubernetes API of clusters on the data plane is used to access Istio resources. A value of true indicates that the Kubernetes API is used.
     */
    @JvmName("vaexgwrnlydrbtus")
    public suspend fun crAggregationEnabled(`value`: Output<Boolean>) {
        this.crAggregationEnabled = value
    }

    /**
     * @param value Whether the data plane KubeAPI access capability is enabled. Indicates whether the Kubernetes API of clusters on the data plane is used to access Istio resources. A value of true indicates that the Kubernetes API is used.
     */
    @JvmName("lawkipsafgjhmmri")
    public suspend fun crAggregationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crAggregationEnabled = mapped
    }

    internal fun build(): ServiceMeshExtraConfigurationArgs = ServiceMeshExtraConfigurationArgs(
        crAggregationEnabled = crAggregationEnabled,
    )
}
