@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.inputs

import com.pulumi.alicloud.servicemesh.inputs.ServiceMeshLoadBalancerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiServerLoadbalancerId The Instance ID of APIServer Load Balancer.
 * @property apiServerPublicEip Indicates whether to use the IP address of a public network exposed API Server.
 * @property pilotPublicEip Indicates whether to use the IP address of a public network exposure Istio Pilot.
 * @property pilotPublicLoadbalancerId The Instance ID of Pilot Load Balancer.
 */
public data class ServiceMeshLoadBalancerArgs(
    public val apiServerLoadbalancerId: Output<String>? = null,
    public val apiServerPublicEip: Output<Boolean>? = null,
    public val pilotPublicEip: Output<Boolean>? = null,
    public val pilotPublicLoadbalancerId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicemesh.inputs.ServiceMeshLoadBalancerArgs> {
    override fun toJava(): com.pulumi.alicloud.servicemesh.inputs.ServiceMeshLoadBalancerArgs =
        com.pulumi.alicloud.servicemesh.inputs.ServiceMeshLoadBalancerArgs.builder()
            .apiServerLoadbalancerId(apiServerLoadbalancerId?.applyValue({ args0 -> args0 }))
            .apiServerPublicEip(apiServerPublicEip?.applyValue({ args0 -> args0 }))
            .pilotPublicEip(pilotPublicEip?.applyValue({ args0 -> args0 }))
            .pilotPublicLoadbalancerId(pilotPublicLoadbalancerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceMeshLoadBalancerArgs].
 */
@PulumiTagMarker
public class ServiceMeshLoadBalancerArgsBuilder internal constructor() {
    private var apiServerLoadbalancerId: Output<String>? = null

    private var apiServerPublicEip: Output<Boolean>? = null

    private var pilotPublicEip: Output<Boolean>? = null

    private var pilotPublicLoadbalancerId: Output<String>? = null

    /**
     * @param value The Instance ID of APIServer Load Balancer.
     */
    @JvmName("ljfcdqwfcbycxxkr")
    public suspend fun apiServerLoadbalancerId(`value`: Output<String>) {
        this.apiServerLoadbalancerId = value
    }

    /**
     * @param value Indicates whether to use the IP address of a public network exposed API Server.
     */
    @JvmName("dwktatwxsxlmgmwn")
    public suspend fun apiServerPublicEip(`value`: Output<Boolean>) {
        this.apiServerPublicEip = value
    }

    /**
     * @param value Indicates whether to use the IP address of a public network exposure Istio Pilot.
     */
    @JvmName("hynfojvymbwblxyj")
    public suspend fun pilotPublicEip(`value`: Output<Boolean>) {
        this.pilotPublicEip = value
    }

    /**
     * @param value The Instance ID of Pilot Load Balancer.
     */
    @JvmName("qmsbgfuajgnauyyq")
    public suspend fun pilotPublicLoadbalancerId(`value`: Output<String>) {
        this.pilotPublicLoadbalancerId = value
    }

    /**
     * @param value The Instance ID of APIServer Load Balancer.
     */
    @JvmName("qlbqqamvflkufckw")
    public suspend fun apiServerLoadbalancerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiServerLoadbalancerId = mapped
    }

    /**
     * @param value Indicates whether to use the IP address of a public network exposed API Server.
     */
    @JvmName("jfklqjxqtvrmudih")
    public suspend fun apiServerPublicEip(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiServerPublicEip = mapped
    }

    /**
     * @param value Indicates whether to use the IP address of a public network exposure Istio Pilot.
     */
    @JvmName("smdftelbuhctuvcm")
    public suspend fun pilotPublicEip(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pilotPublicEip = mapped
    }

    /**
     * @param value The Instance ID of Pilot Load Balancer.
     */
    @JvmName("halsqhjsxugpsxdr")
    public suspend fun pilotPublicLoadbalancerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pilotPublicLoadbalancerId = mapped
    }

    internal fun build(): ServiceMeshLoadBalancerArgs = ServiceMeshLoadBalancerArgs(
        apiServerLoadbalancerId = apiServerLoadbalancerId,
        apiServerPublicEip = apiServerPublicEip,
        pilotPublicEip = pilotPublicEip,
        pilotPublicLoadbalancerId = pilotPublicLoadbalancerId,
    )
}
