@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.inputs

import com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigAccessLogArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enable CNI.
 * @property gatewayEnabled Whether collect AccessLog of ASM Gateway to Alibaba Cloud SLS.
 * @property gatewayLifecycle Lifecycle of AccessLog of ASM Gateways which have been collected to Alibaba Cloud SLS.
 * @property project The name of the SLS Project to which the control plane logs are collected.
 * @property sidecarEnabled Whether collect AccessLog of ASM Gateway to Alibaba Cloud SLS.
 * @property sidecarLifecycle Lifecycle of AccessLog of ASM Sidecars which have been collected to Alibaba Cloud SLS.
 */
public data class ServiceMeshMeshConfigAccessLogArgs(
    public val enabled: Output<Boolean>? = null,
    public val gatewayEnabled: Output<Boolean>? = null,
    public val gatewayLifecycle: Output<Int>? = null,
    public val project: Output<String>? = null,
    public val sidecarEnabled: Output<Boolean>? = null,
    public val sidecarLifecycle: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigAccessLogArgs> {
    override fun toJava(): com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigAccessLogArgs =
        com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigAccessLogArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .gatewayEnabled(gatewayEnabled?.applyValue({ args0 -> args0 }))
            .gatewayLifecycle(gatewayLifecycle?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .sidecarEnabled(sidecarEnabled?.applyValue({ args0 -> args0 }))
            .sidecarLifecycle(sidecarLifecycle?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceMeshMeshConfigAccessLogArgs].
 */
@PulumiTagMarker
public class ServiceMeshMeshConfigAccessLogArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var gatewayEnabled: Output<Boolean>? = null

    private var gatewayLifecycle: Output<Int>? = null

    private var project: Output<String>? = null

    private var sidecarEnabled: Output<Boolean>? = null

    private var sidecarLifecycle: Output<Int>? = null

    /**
     * @param value Enable CNI.
     */
    @JvmName("nypqlghbnavitoho")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Whether collect AccessLog of ASM Gateway to Alibaba Cloud SLS.
     */
    @JvmName("pvsqgbjvjgeaqaoy")
    public suspend fun gatewayEnabled(`value`: Output<Boolean>) {
        this.gatewayEnabled = value
    }

    /**
     * @param value Lifecycle of AccessLog of ASM Gateways which have been collected to Alibaba Cloud SLS.
     */
    @JvmName("nhruxigbqrjwrlia")
    public suspend fun gatewayLifecycle(`value`: Output<Int>) {
        this.gatewayLifecycle = value
    }

    /**
     * @param value The name of the SLS Project to which the control plane logs are collected.
     */
    @JvmName("kdoexvhtxruumtdn")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Whether collect AccessLog of ASM Gateway to Alibaba Cloud SLS.
     */
    @JvmName("ticmllcoaiioqvhr")
    public suspend fun sidecarEnabled(`value`: Output<Boolean>) {
        this.sidecarEnabled = value
    }

    /**
     * @param value Lifecycle of AccessLog of ASM Sidecars which have been collected to Alibaba Cloud SLS.
     */
    @JvmName("sanfovchnnpkokbg")
    public suspend fun sidecarLifecycle(`value`: Output<Int>) {
        this.sidecarLifecycle = value
    }

    /**
     * @param value Enable CNI.
     */
    @JvmName("kqvcajlogcwblhau")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Whether collect AccessLog of ASM Gateway to Alibaba Cloud SLS.
     */
    @JvmName("vudiwvqrkldqykxl")
    public suspend fun gatewayEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayEnabled = mapped
    }

    /**
     * @param value Lifecycle of AccessLog of ASM Gateways which have been collected to Alibaba Cloud SLS.
     */
    @JvmName("sbixjtieqmtudyat")
    public suspend fun gatewayLifecycle(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayLifecycle = mapped
    }

    /**
     * @param value The name of the SLS Project to which the control plane logs are collected.
     */
    @JvmName("xjdyyhpunowppnkq")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value Whether collect AccessLog of ASM Gateway to Alibaba Cloud SLS.
     */
    @JvmName("qjpdsrpcyhfujfuf")
    public suspend fun sidecarEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sidecarEnabled = mapped
    }

    /**
     * @param value Lifecycle of AccessLog of ASM Sidecars which have been collected to Alibaba Cloud SLS.
     */
    @JvmName("ateytyswpsvxxpaq")
    public suspend fun sidecarLifecycle(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sidecarLifecycle = mapped
    }

    internal fun build(): ServiceMeshMeshConfigAccessLogArgs = ServiceMeshMeshConfigAccessLogArgs(
        enabled = enabled,
        gatewayEnabled = gatewayEnabled,
        gatewayLifecycle = gatewayLifecycle,
        project = project,
        sidecarEnabled = sidecarEnabled,
        sidecarLifecycle = sidecarLifecycle,
    )
}
