@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.inputs

import com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property accessLog The access logging configuration. See `access_log` below.
 * @property audit Audit information. See `audit` below.
 * @property controlPlaneLog Control plane log collection configuration. See `control_plane_log` below.
 * @property customizedZipkin Whether or not to enable the use of a custom zipkin.
 * @property enableLocalityLb Whether to enable service can access the service through the nearest node access.
 * @property includeIpRanges The IP ADDRESS range.
 * @property kiali Kiali configuration. See `kiali` below.
 * @property opa The open-door policy of agent (OPA) plug-in information. See `opa` below.
 * @property outboundTrafficPolicy Out to the traffic policy.
 * @property pilot Link trace sampling information. See `pilot` below.
 * @property prometheus Prometheus configuration.
 * @property proxy Proxy configuration. See `proxy` below.
 * @property sidecarInjector Sidecar injector configuration. See `sidecar_injector` below.
 * @property telemetry Whether to enable acquisition Prometheus metrics (it is recommended that you use [Alibaba Cloud Prometheus monitoring](https://arms.console.aliyun.com/).
 * @property tracing Whether to enable link trace (you need to have [Alibaba Cloud link tracking service](https://tracing-analysis.console.aliyun.com/).
 */
public data class ServiceMeshMeshConfigArgs(
    public val accessLog: Output<ServiceMeshMeshConfigAccessLogArgs>? = null,
    public val audit: Output<ServiceMeshMeshConfigAuditArgs>? = null,
    public val controlPlaneLog: Output<ServiceMeshMeshConfigControlPlaneLogArgs>? = null,
    public val customizedZipkin: Output<Boolean>? = null,
    public val enableLocalityLb: Output<Boolean>? = null,
    public val includeIpRanges: Output<String>? = null,
    public val kiali: Output<ServiceMeshMeshConfigKialiArgs>? = null,
    public val opa: Output<ServiceMeshMeshConfigOpaArgs>? = null,
    public val outboundTrafficPolicy: Output<String>? = null,
    public val pilot: Output<ServiceMeshMeshConfigPilotArgs>? = null,
    public val prometheus: Output<ServiceMeshMeshConfigPrometheusArgs>? = null,
    public val proxy: Output<ServiceMeshMeshConfigProxyArgs>? = null,
    public val sidecarInjector: Output<ServiceMeshMeshConfigSidecarInjectorArgs>? = null,
    public val telemetry: Output<Boolean>? = null,
    public val tracing: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigArgs =
        com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigArgs.builder()
            .accessLog(accessLog?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .audit(audit?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .controlPlaneLog(controlPlaneLog?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customizedZipkin(customizedZipkin?.applyValue({ args0 -> args0 }))
            .enableLocalityLb(enableLocalityLb?.applyValue({ args0 -> args0 }))
            .includeIpRanges(includeIpRanges?.applyValue({ args0 -> args0 }))
            .kiali(kiali?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .opa(opa?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .outboundTrafficPolicy(outboundTrafficPolicy?.applyValue({ args0 -> args0 }))
            .pilot(pilot?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .prometheus(prometheus?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .proxy(proxy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sidecarInjector(sidecarInjector?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .telemetry(telemetry?.applyValue({ args0 -> args0 }))
            .tracing(tracing?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceMeshMeshConfigArgs].
 */
@PulumiTagMarker
public class ServiceMeshMeshConfigArgsBuilder internal constructor() {
    private var accessLog: Output<ServiceMeshMeshConfigAccessLogArgs>? = null

    private var audit: Output<ServiceMeshMeshConfigAuditArgs>? = null

    private var controlPlaneLog: Output<ServiceMeshMeshConfigControlPlaneLogArgs>? = null

    private var customizedZipkin: Output<Boolean>? = null

    private var enableLocalityLb: Output<Boolean>? = null

    private var includeIpRanges: Output<String>? = null

    private var kiali: Output<ServiceMeshMeshConfigKialiArgs>? = null

    private var opa: Output<ServiceMeshMeshConfigOpaArgs>? = null

    private var outboundTrafficPolicy: Output<String>? = null

    private var pilot: Output<ServiceMeshMeshConfigPilotArgs>? = null

    private var prometheus: Output<ServiceMeshMeshConfigPrometheusArgs>? = null

    private var proxy: Output<ServiceMeshMeshConfigProxyArgs>? = null

    private var sidecarInjector: Output<ServiceMeshMeshConfigSidecarInjectorArgs>? = null

    private var telemetry: Output<Boolean>? = null

    private var tracing: Output<Boolean>? = null

    /**
     * @param value The access logging configuration. See `access_log` below.
     */
    @JvmName("qqalqgyfwrcaxckg")
    public suspend fun accessLog(`value`: Output<ServiceMeshMeshConfigAccessLogArgs>) {
        this.accessLog = value
    }

    /**
     * @param value Audit information. See `audit` below.
     */
    @JvmName("qlfvfwyaopyfubns")
    public suspend fun audit(`value`: Output<ServiceMeshMeshConfigAuditArgs>) {
        this.audit = value
    }

    /**
     * @param value Control plane log collection configuration. See `control_plane_log` below.
     */
    @JvmName("wdmpogkdyharpudl")
    public suspend fun controlPlaneLog(`value`: Output<ServiceMeshMeshConfigControlPlaneLogArgs>) {
        this.controlPlaneLog = value
    }

    /**
     * @param value Whether or not to enable the use of a custom zipkin.
     */
    @JvmName("uskgsnwmmeawcvgj")
    public suspend fun customizedZipkin(`value`: Output<Boolean>) {
        this.customizedZipkin = value
    }

    /**
     * @param value Whether to enable service can access the service through the nearest node access.
     */
    @JvmName("qmtpvdawgpprtthe")
    public suspend fun enableLocalityLb(`value`: Output<Boolean>) {
        this.enableLocalityLb = value
    }

    /**
     * @param value The IP ADDRESS range.
     */
    @JvmName("ohfnjxatnchjpfkl")
    public suspend fun includeIpRanges(`value`: Output<String>) {
        this.includeIpRanges = value
    }

    /**
     * @param value Kiali configuration. See `kiali` below.
     */
    @JvmName("ocbgfssxqukhtlkb")
    public suspend fun kiali(`value`: Output<ServiceMeshMeshConfigKialiArgs>) {
        this.kiali = value
    }

    /**
     * @param value The open-door policy of agent (OPA) plug-in information. See `opa` below.
     */
    @JvmName("jlevplmhxyqudjtw")
    public suspend fun opa(`value`: Output<ServiceMeshMeshConfigOpaArgs>) {
        this.opa = value
    }

    /**
     * @param value Out to the traffic policy.
     */
    @JvmName("tfcgexadnkpgcixl")
    public suspend fun outboundTrafficPolicy(`value`: Output<String>) {
        this.outboundTrafficPolicy = value
    }

    /**
     * @param value Link trace sampling information. See `pilot` below.
     */
    @JvmName("voohitjulecwcdai")
    public suspend fun pilot(`value`: Output<ServiceMeshMeshConfigPilotArgs>) {
        this.pilot = value
    }

    /**
     * @param value Prometheus configuration.
     */
    @JvmName("xojvqsbuyfyuppbj")
    public suspend fun prometheus(`value`: Output<ServiceMeshMeshConfigPrometheusArgs>) {
        this.prometheus = value
    }

    /**
     * @param value Proxy configuration. See `proxy` below.
     */
    @JvmName("pnavxarvjdjvjtvh")
    public suspend fun proxy(`value`: Output<ServiceMeshMeshConfigProxyArgs>) {
        this.proxy = value
    }

    /**
     * @param value Sidecar injector configuration. See `sidecar_injector` below.
     */
    @JvmName("ceasbmfsksbsjuet")
    public suspend fun sidecarInjector(`value`: Output<ServiceMeshMeshConfigSidecarInjectorArgs>) {
        this.sidecarInjector = value
    }

    /**
     * @param value Whether to enable acquisition Prometheus metrics (it is recommended that you use [Alibaba Cloud Prometheus monitoring](https://arms.console.aliyun.com/).
     */
    @JvmName("qsnkjxvsnhcjqwki")
    public suspend fun telemetry(`value`: Output<Boolean>) {
        this.telemetry = value
    }

    /**
     * @param value Whether to enable link trace (you need to have [Alibaba Cloud link tracking service](https://tracing-analysis.console.aliyun.com/).
     */
    @JvmName("olyxytohretvfeav")
    public suspend fun tracing(`value`: Output<Boolean>) {
        this.tracing = value
    }

    /**
     * @param value The access logging configuration. See `access_log` below.
     */
    @JvmName("jeiggynjkkjfgufj")
    public suspend fun accessLog(`value`: ServiceMeshMeshConfigAccessLogArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLog = mapped
    }

    /**
     * @param argument The access logging configuration. See `access_log` below.
     */
    @JvmName("sfemsllvtwtnboqh")
    public suspend fun accessLog(argument: suspend ServiceMeshMeshConfigAccessLogArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceMeshMeshConfigAccessLogArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessLog = mapped
    }

    /**
     * @param value Audit information. See `audit` below.
     */
    @JvmName("ighkbsqwbkdnqlqn")
    public suspend fun audit(`value`: ServiceMeshMeshConfigAuditArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audit = mapped
    }

    /**
     * @param argument Audit information. See `audit` below.
     */
    @JvmName("eygarjkgqkfsucik")
    public suspend fun audit(argument: suspend ServiceMeshMeshConfigAuditArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceMeshMeshConfigAuditArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.audit = mapped
    }

    /**
     * @param value Control plane log collection configuration. See `control_plane_log` below.
     */
    @JvmName("qhclhmfwnqbqeysu")
    public suspend fun controlPlaneLog(`value`: ServiceMeshMeshConfigControlPlaneLogArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlPlaneLog = mapped
    }

    /**
     * @param argument Control plane log collection configuration. See `control_plane_log` below.
     */
    @JvmName("ifamipyixkvvclep")
    public suspend fun controlPlaneLog(argument: suspend ServiceMeshMeshConfigControlPlaneLogArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceMeshMeshConfigControlPlaneLogArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.controlPlaneLog = mapped
    }

    /**
     * @param value Whether or not to enable the use of a custom zipkin.
     */
    @JvmName("joqavriqfdnimgoj")
    public suspend fun customizedZipkin(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customizedZipkin = mapped
    }

    /**
     * @param value Whether to enable service can access the service through the nearest node access.
     */
    @JvmName("lnixihrfnorjlryx")
    public suspend fun enableLocalityLb(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableLocalityLb = mapped
    }

    /**
     * @param value The IP ADDRESS range.
     */
    @JvmName("drlnmpmbtuwabcic")
    public suspend fun includeIpRanges(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeIpRanges = mapped
    }

    /**
     * @param value Kiali configuration. See `kiali` below.
     */
    @JvmName("khaxsexlhvxyegba")
    public suspend fun kiali(`value`: ServiceMeshMeshConfigKialiArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kiali = mapped
    }

    /**
     * @param argument Kiali configuration. See `kiali` below.
     */
    @JvmName("gcifagoborgrplmd")
    public suspend fun kiali(argument: suspend ServiceMeshMeshConfigKialiArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceMeshMeshConfigKialiArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kiali = mapped
    }

    /**
     * @param value The open-door policy of agent (OPA) plug-in information. See `opa` below.
     */
    @JvmName("vhkrvravdofhvrfg")
    public suspend fun opa(`value`: ServiceMeshMeshConfigOpaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.opa = mapped
    }

    /**
     * @param argument The open-door policy of agent (OPA) plug-in information. See `opa` below.
     */
    @JvmName("lfbkigpjvtcwjcrv")
    public suspend fun opa(argument: suspend ServiceMeshMeshConfigOpaArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceMeshMeshConfigOpaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.opa = mapped
    }

    /**
     * @param value Out to the traffic policy.
     */
    @JvmName("fmkjksxgnfmgtvcr")
    public suspend fun outboundTrafficPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outboundTrafficPolicy = mapped
    }

    /**
     * @param value Link trace sampling information. See `pilot` below.
     */
    @JvmName("vsttndcnynpalsuu")
    public suspend fun pilot(`value`: ServiceMeshMeshConfigPilotArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pilot = mapped
    }

    /**
     * @param argument Link trace sampling information. See `pilot` below.
     */
    @JvmName("xicgcjjmhsnlyhkw")
    public suspend fun pilot(argument: suspend ServiceMeshMeshConfigPilotArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceMeshMeshConfigPilotArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.pilot = mapped
    }

    /**
     * @param value Prometheus configuration.
     */
    @JvmName("qvsubrtygeyrkjti")
    public suspend fun prometheus(`value`: ServiceMeshMeshConfigPrometheusArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prometheus = mapped
    }

    /**
     * @param argument Prometheus configuration.
     */
    @JvmName("fwqnjogvqeuaetpp")
    public suspend fun prometheus(argument: suspend ServiceMeshMeshConfigPrometheusArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceMeshMeshConfigPrometheusArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.prometheus = mapped
    }

    /**
     * @param value Proxy configuration. See `proxy` below.
     */
    @JvmName("hqbeyqigkasefohj")
    public suspend fun proxy(`value`: ServiceMeshMeshConfigProxyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxy = mapped
    }

    /**
     * @param argument Proxy configuration. See `proxy` below.
     */
    @JvmName("kthbmhkelfmcyjmm")
    public suspend fun proxy(argument: suspend ServiceMeshMeshConfigProxyArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceMeshMeshConfigProxyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.proxy = mapped
    }

    /**
     * @param value Sidecar injector configuration. See `sidecar_injector` below.
     */
    @JvmName("qrelrhotydbpkikn")
    public suspend fun sidecarInjector(`value`: ServiceMeshMeshConfigSidecarInjectorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sidecarInjector = mapped
    }

    /**
     * @param argument Sidecar injector configuration. See `sidecar_injector` below.
     */
    @JvmName("gmxjrtxvbfryidey")
    public suspend fun sidecarInjector(argument: suspend ServiceMeshMeshConfigSidecarInjectorArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceMeshMeshConfigSidecarInjectorArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sidecarInjector = mapped
    }

    /**
     * @param value Whether to enable acquisition Prometheus metrics (it is recommended that you use [Alibaba Cloud Prometheus monitoring](https://arms.console.aliyun.com/).
     */
    @JvmName("gmewlvwstfnsiaqc")
    public suspend fun telemetry(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.telemetry = mapped
    }

    /**
     * @param value Whether to enable link trace (you need to have [Alibaba Cloud link tracking service](https://tracing-analysis.console.aliyun.com/).
     */
    @JvmName("ohwpdiiadxmbbsok")
    public suspend fun tracing(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tracing = mapped
    }

    internal fun build(): ServiceMeshMeshConfigArgs = ServiceMeshMeshConfigArgs(
        accessLog = accessLog,
        audit = audit,
        controlPlaneLog = controlPlaneLog,
        customizedZipkin = customizedZipkin,
        enableLocalityLb = enableLocalityLb,
        includeIpRanges = includeIpRanges,
        kiali = kiali,
        opa = opa,
        outboundTrafficPolicy = outboundTrafficPolicy,
        pilot = pilot,
        prometheus = prometheus,
        proxy = proxy,
        sidecarInjector = sidecarInjector,
        telemetry = telemetry,
        tracing = tracing,
    )
}
