@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.inputs

import com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigAuditArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enable CNI.
 * @property project The name of the SLS Project to which the control plane logs are collected.
 */
public data class ServiceMeshMeshConfigAuditArgs(
    public val enabled: Output<Boolean>? = null,
    public val project: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigAuditArgs> {
    override fun toJava(): com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigAuditArgs =
        com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigAuditArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceMeshMeshConfigAuditArgs].
 */
@PulumiTagMarker
public class ServiceMeshMeshConfigAuditArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var project: Output<String>? = null

    /**
     * @param value Enable CNI.
     */
    @JvmName("lxhvqkjjgchhkjbb")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The name of the SLS Project to which the control plane logs are collected.
     */
    @JvmName("digkwukmawgnjvaj")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Enable CNI.
     */
    @JvmName("pvbrdnwuhwffwqrk")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The name of the SLS Project to which the control plane logs are collected.
     */
    @JvmName("hfgdeqbxfimpnjpa")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    internal fun build(): ServiceMeshMeshConfigAuditArgs = ServiceMeshMeshConfigAuditArgs(
        enabled = enabled,
        project = project,
    )
}
