@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.inputs

import com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigControlPlaneLogArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enable CNI.
 * @property logTtlInDay Lifecycle of logs has been collected to Alibaba Cloud SLS.
 * @property project The name of the SLS Project to which the control plane logs are collected.
 */
public data class ServiceMeshMeshConfigControlPlaneLogArgs(
    public val enabled: Output<Boolean>,
    public val logTtlInDay: Output<Int>? = null,
    public val project: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigControlPlaneLogArgs> {
    override fun toJava(): com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigControlPlaneLogArgs =
        com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigControlPlaneLogArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .logTtlInDay(logTtlInDay?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceMeshMeshConfigControlPlaneLogArgs].
 */
@PulumiTagMarker
public class ServiceMeshMeshConfigControlPlaneLogArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var logTtlInDay: Output<Int>? = null

    private var project: Output<String>? = null

    /**
     * @param value Enable CNI.
     */
    @JvmName("ijuawpgfokbnlahs")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Lifecycle of logs has been collected to Alibaba Cloud SLS.
     */
    @JvmName("fojphesymfrdcowc")
    public suspend fun logTtlInDay(`value`: Output<Int>) {
        this.logTtlInDay = value
    }

    /**
     * @param value The name of the SLS Project to which the control plane logs are collected.
     */
    @JvmName("opurjasfiwqemtww")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Enable CNI.
     */
    @JvmName("icgdxwkfvncfpvgj")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Lifecycle of logs has been collected to Alibaba Cloud SLS.
     */
    @JvmName("jgggihxgeomcjpab")
    public suspend fun logTtlInDay(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logTtlInDay = mapped
    }

    /**
     * @param value The name of the SLS Project to which the control plane logs are collected.
     */
    @JvmName("oycqjkajlvdfdkgw")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    internal fun build(): ServiceMeshMeshConfigControlPlaneLogArgs =
        ServiceMeshMeshConfigControlPlaneLogArgs(
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
            logTtlInDay = logTtlInDay,
            project = project,
        )
}
