@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.inputs

import com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigKialiArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enable CNI.
 * @property url Kiali service address.
 */
public data class ServiceMeshMeshConfigKialiArgs(
    public val enabled: Output<Boolean>? = null,
    public val url: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigKialiArgs> {
    override fun toJava(): com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigKialiArgs =
        com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigKialiArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceMeshMeshConfigKialiArgs].
 */
@PulumiTagMarker
public class ServiceMeshMeshConfigKialiArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var url: Output<String>? = null

    /**
     * @param value Enable CNI.
     */
    @JvmName("ojnjgulaowlqxrlh")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Kiali service address.
     */
    @JvmName("abtpqdoqgciqfhqn")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value Enable CNI.
     */
    @JvmName("limsyhsxvjqiyqdn")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Kiali service address.
     */
    @JvmName("enrrwvmhlgsobttr")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): ServiceMeshMeshConfigKialiArgs = ServiceMeshMeshConfigKialiArgs(
        enabled = enabled,
        url = url,
    )
}
