@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.inputs

import com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigOpaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enable CNI.
 * @property limitCpu Sidecar injector Pods on the throttle.
 * @property limitMemory Sidecar injector Pods on the throttle.
 * @property logLevel OPA proxy container log level.
 * @property requestCpu Sidecar injector Pods on the requested resource.
 * @property requestMemory Sidecar injector Pods on the requested resource.
 */
public data class ServiceMeshMeshConfigOpaArgs(
    public val enabled: Output<Boolean>? = null,
    public val limitCpu: Output<String>? = null,
    public val limitMemory: Output<String>? = null,
    public val logLevel: Output<String>? = null,
    public val requestCpu: Output<String>? = null,
    public val requestMemory: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigOpaArgs> {
    override fun toJava(): com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigOpaArgs =
        com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigOpaArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .limitCpu(limitCpu?.applyValue({ args0 -> args0 }))
            .limitMemory(limitMemory?.applyValue({ args0 -> args0 }))
            .logLevel(logLevel?.applyValue({ args0 -> args0 }))
            .requestCpu(requestCpu?.applyValue({ args0 -> args0 }))
            .requestMemory(requestMemory?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceMeshMeshConfigOpaArgs].
 */
@PulumiTagMarker
public class ServiceMeshMeshConfigOpaArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var limitCpu: Output<String>? = null

    private var limitMemory: Output<String>? = null

    private var logLevel: Output<String>? = null

    private var requestCpu: Output<String>? = null

    private var requestMemory: Output<String>? = null

    /**
     * @param value Enable CNI.
     */
    @JvmName("rtyomtycrhpqxuhu")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Sidecar injector Pods on the throttle.
     */
    @JvmName("nxhugehkxupsrhmk")
    public suspend fun limitCpu(`value`: Output<String>) {
        this.limitCpu = value
    }

    /**
     * @param value Sidecar injector Pods on the throttle.
     */
    @JvmName("fryixquxddmtinbv")
    public suspend fun limitMemory(`value`: Output<String>) {
        this.limitMemory = value
    }

    /**
     * @param value OPA proxy container log level.
     */
    @JvmName("wfcmwwdwqgjwoxia")
    public suspend fun logLevel(`value`: Output<String>) {
        this.logLevel = value
    }

    /**
     * @param value Sidecar injector Pods on the requested resource.
     */
    @JvmName("qwvviqtcugbiguqx")
    public suspend fun requestCpu(`value`: Output<String>) {
        this.requestCpu = value
    }

    /**
     * @param value Sidecar injector Pods on the requested resource.
     */
    @JvmName("pkiuqqanjthkoqfk")
    public suspend fun requestMemory(`value`: Output<String>) {
        this.requestMemory = value
    }

    /**
     * @param value Enable CNI.
     */
    @JvmName("mlulvrdxmbtgybmr")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Sidecar injector Pods on the throttle.
     */
    @JvmName("qsdpjnbjekyvjoel")
    public suspend fun limitCpu(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limitCpu = mapped
    }

    /**
     * @param value Sidecar injector Pods on the throttle.
     */
    @JvmName("vxoqxjiacnisqbjv")
    public suspend fun limitMemory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limitMemory = mapped
    }

    /**
     * @param value OPA proxy container log level.
     */
    @JvmName("tfxuthcprjxdamby")
    public suspend fun logLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    /**
     * @param value Sidecar injector Pods on the requested resource.
     */
    @JvmName("ynphinqfnxqrysnq")
    public suspend fun requestCpu(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestCpu = mapped
    }

    /**
     * @param value Sidecar injector Pods on the requested resource.
     */
    @JvmName("bfpytnunimxvnkem")
    public suspend fun requestMemory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestMemory = mapped
    }

    internal fun build(): ServiceMeshMeshConfigOpaArgs = ServiceMeshMeshConfigOpaArgs(
        enabled = enabled,
        limitCpu = limitCpu,
        limitMemory = limitMemory,
        logLevel = logLevel,
        requestCpu = requestCpu,
        requestMemory = requestMemory,
    )
}
