@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.inputs

import com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigPilotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property http10Enabled Whether to support the HTTP1.0.
 * @property traceSampling Link trace sampling percentage.
 */
public data class ServiceMeshMeshConfigPilotArgs(
    public val http10Enabled: Output<Boolean>? = null,
    public val traceSampling: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigPilotArgs> {
    override fun toJava(): com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigPilotArgs =
        com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigPilotArgs.builder()
            .http10Enabled(http10Enabled?.applyValue({ args0 -> args0 }))
            .traceSampling(traceSampling?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceMeshMeshConfigPilotArgs].
 */
@PulumiTagMarker
public class ServiceMeshMeshConfigPilotArgsBuilder internal constructor() {
    private var http10Enabled: Output<Boolean>? = null

    private var traceSampling: Output<Double>? = null

    /**
     * @param value Whether to support the HTTP1.0.
     */
    @JvmName("ofexvoattqrmohxa")
    public suspend fun http10Enabled(`value`: Output<Boolean>) {
        this.http10Enabled = value
    }

    /**
     * @param value Link trace sampling percentage.
     */
    @JvmName("yspcultuokrpabaq")
    public suspend fun traceSampling(`value`: Output<Double>) {
        this.traceSampling = value
    }

    /**
     * @param value Whether to support the HTTP1.0.
     */
    @JvmName("ldhiclemntgcixsg")
    public suspend fun http10Enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.http10Enabled = mapped
    }

    /**
     * @param value Link trace sampling percentage.
     */
    @JvmName("odwahqiigcmyqiau")
    public suspend fun traceSampling(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.traceSampling = mapped
    }

    internal fun build(): ServiceMeshMeshConfigPilotArgs = ServiceMeshMeshConfigPilotArgs(
        http10Enabled = http10Enabled,
        traceSampling = traceSampling,
    )
}
