@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.inputs

import com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigPrometheusArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property externalUrl Prometheus service addresses (enabled external Prometheus when the system automatically populates).
 * @property useExternal Whether to enable external Prometheus.
 */
public data class ServiceMeshMeshConfigPrometheusArgs(
    public val externalUrl: Output<String>? = null,
    public val useExternal: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigPrometheusArgs> {
    override fun toJava(): com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigPrometheusArgs = com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigPrometheusArgs.builder()
        .externalUrl(externalUrl?.applyValue({ args0 -> args0 }))
        .useExternal(useExternal?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceMeshMeshConfigPrometheusArgs].
 */
@PulumiTagMarker
public class ServiceMeshMeshConfigPrometheusArgsBuilder internal constructor() {
    private var externalUrl: Output<String>? = null

    private var useExternal: Output<Boolean>? = null

    /**
     * @param value Prometheus service addresses (enabled external Prometheus when the system automatically populates).
     */
    @JvmName("kbnnuiskaxarpwke")
    public suspend fun externalUrl(`value`: Output<String>) {
        this.externalUrl = value
    }

    /**
     * @param value Whether to enable external Prometheus.
     */
    @JvmName("atxsrvdfjrngpbqj")
    public suspend fun useExternal(`value`: Output<Boolean>) {
        this.useExternal = value
    }

    /**
     * @param value Prometheus service addresses (enabled external Prometheus when the system automatically populates).
     */
    @JvmName("pgkdghbqtcxkbuuu")
    public suspend fun externalUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalUrl = mapped
    }

    /**
     * @param value Whether to enable external Prometheus.
     */
    @JvmName("xobjrgxjxswckwjb")
    public suspend fun useExternal(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useExternal = mapped
    }

    internal fun build(): ServiceMeshMeshConfigPrometheusArgs = ServiceMeshMeshConfigPrometheusArgs(
        externalUrl = externalUrl,
        useExternal = useExternal,
    )
}
