@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.inputs

import com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigProxyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterDomain Cluster domain name.
 * @property limitCpu Sidecar injector Pods on the throttle.
 * @property limitMemory Sidecar injector Pods on the throttle.
 * @property requestCpu Sidecar injector Pods on the requested resource.
 * @property requestMemory Sidecar injector Pods on the requested resource.
 */
public data class ServiceMeshMeshConfigProxyArgs(
    public val clusterDomain: Output<String>? = null,
    public val limitCpu: Output<String>? = null,
    public val limitMemory: Output<String>? = null,
    public val requestCpu: Output<String>? = null,
    public val requestMemory: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigProxyArgs> {
    override fun toJava(): com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigProxyArgs =
        com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigProxyArgs.builder()
            .clusterDomain(clusterDomain?.applyValue({ args0 -> args0 }))
            .limitCpu(limitCpu?.applyValue({ args0 -> args0 }))
            .limitMemory(limitMemory?.applyValue({ args0 -> args0 }))
            .requestCpu(requestCpu?.applyValue({ args0 -> args0 }))
            .requestMemory(requestMemory?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceMeshMeshConfigProxyArgs].
 */
@PulumiTagMarker
public class ServiceMeshMeshConfigProxyArgsBuilder internal constructor() {
    private var clusterDomain: Output<String>? = null

    private var limitCpu: Output<String>? = null

    private var limitMemory: Output<String>? = null

    private var requestCpu: Output<String>? = null

    private var requestMemory: Output<String>? = null

    /**
     * @param value Cluster domain name.
     */
    @JvmName("inlsupkqtudagemt")
    public suspend fun clusterDomain(`value`: Output<String>) {
        this.clusterDomain = value
    }

    /**
     * @param value Sidecar injector Pods on the throttle.
     */
    @JvmName("uxpfjntjydamwmrb")
    public suspend fun limitCpu(`value`: Output<String>) {
        this.limitCpu = value
    }

    /**
     * @param value Sidecar injector Pods on the throttle.
     */
    @JvmName("lopcixfrtdmjbomo")
    public suspend fun limitMemory(`value`: Output<String>) {
        this.limitMemory = value
    }

    /**
     * @param value Sidecar injector Pods on the requested resource.
     */
    @JvmName("ogccqswsxhltlnoi")
    public suspend fun requestCpu(`value`: Output<String>) {
        this.requestCpu = value
    }

    /**
     * @param value Sidecar injector Pods on the requested resource.
     */
    @JvmName("bkxaerudmyilatxh")
    public suspend fun requestMemory(`value`: Output<String>) {
        this.requestMemory = value
    }

    /**
     * @param value Cluster domain name.
     */
    @JvmName("mkxcrnhplfcyopth")
    public suspend fun clusterDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterDomain = mapped
    }

    /**
     * @param value Sidecar injector Pods on the throttle.
     */
    @JvmName("bnfmnbkfuvauohli")
    public suspend fun limitCpu(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limitCpu = mapped
    }

    /**
     * @param value Sidecar injector Pods on the throttle.
     */
    @JvmName("jkbsdlwrdlmyjtox")
    public suspend fun limitMemory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limitMemory = mapped
    }

    /**
     * @param value Sidecar injector Pods on the requested resource.
     */
    @JvmName("dvfgciwrckwjfiaf")
    public suspend fun requestCpu(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestCpu = mapped
    }

    /**
     * @param value Sidecar injector Pods on the requested resource.
     */
    @JvmName("axkkxbtsyifqwmsw")
    public suspend fun requestMemory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestMemory = mapped
    }

    internal fun build(): ServiceMeshMeshConfigProxyArgs = ServiceMeshMeshConfigProxyArgs(
        clusterDomain = clusterDomain,
        limitCpu = limitCpu,
        limitMemory = limitMemory,
        requestCpu = requestCpu,
        requestMemory = requestMemory,
    )
}
